/*
 * Data patch for filtering validation rules and targeting rules which do not include UA targeting rule for UA title
 * Purpose: All validation rule should not work for UA title, and all the targeting rule except 'Mediaroom_UA Targeting' should not work for UA title.
 * Author: Zhiling Zhang on 7 May 2015
 * Modified script to plpgsql by Suresh Neravati on 08/23/2017
 */
DO $$ 
DECLARE
   recursor       cursor FOR SELECT RULESETID,RULENAME,TITLEFILTERID
                       FROM TRE_RULESET t
                      WHERE (PACKAGEID=(SELECT PACKAGEID FROM TRE_PACKAGE WHERE NAME='VALIDATION') OR
                             PACKAGEID=(SELECT PACKAGEID FROM TRE_PACKAGE WHERE NAME='TARGETING'))
                        AND NOT EXISTS(SELECT * FROM TRE_RULESET
                                        WHERE RULESETID = t.RULESETID
                                          AND RULENAME in ('OOB_CL11_I06 rules','OOB_CL11_Check total length',
                                          'OOB_Mediaroom_UA Targeting', 'OOB_Viewing Policy Targeting'));
   t_packageid    numeric(10,0);
   t_rulesetid    numeric(10,0);
   rulesetname    text;
   filterid       numeric(10,0);
   rec_count      numeric(10,0);
   nodenum        numeric(10,0);
   t_rootnodeid   numeric(10,0);
   t_predicatedid numeric(10,0);
   
BEGIN
   OPEN recursor;
   LOOP
     FETCH recursor INTO t_rulesetid,rulesetname,filterid;
     EXIT WHEN NOT FOUND;
     RAISE NOTICE 'processing rule:%, rulesetid: %, filterid: %', rulesetname, t_rulesetid, filterid;
     SELECT count(*) INTO rec_count FROM TRE_TITLEFILTER WHERE TITLEFILTERID = filterid AND ROOTNODEID is NULL;
     IF rec_count > 0  THEN
       SELECT nextval('TRE_EXPNODE_SEQ') INTO t_rootnodeid;
       INSERT INTO TRE_EXPNODE VALUES(t_rootnodeid,'List', NULL,'AND',NULL,NULL,now(),now());
       UPDATE TRE_TITLEFILTER SET ROOTNODEID=t_rootnodeid WHERE TITLEFILTERID = filterid;
       RAISE NOTICE 'root node id is null,after updated TRE_TITLEFILTER table,root node id is: %', t_rootnodeid;
     END IF;
     SELECT ROOTNODEID INTO t_rootnodeid FROM TRE_TITLEFILTER WHERE TITLEFILTERID = filterid;
     RAISE NOTICE 'root node id is: %', t_rootnodeid;
     SELECT count(*) INTO nodenum FROM TRE_EXPNODE exp WHERE PARENTID = t_rootnodeid 
        AND exists (SELECT * FROM TRE_PREDICATE pre WHERE FIELDLEFT='/Fields/ContentType' AND pre.PREDICATEID = exp.PREDICATEID); 
     IF nodenum=0 THEN
       SELECT nextval('TRE_PREDICATE_SEQ') INTO t_predicatedid;
       INSERT INTO TRE_PREDICATE VALUES(t_predicatedid,'V',0,'/Fields/ContentType',NULL,'PACKAGE/TITLE',NULL,'ASSET',NULL,1,'EQUAL',NULL,NULL,0,now(),now());
       INSERT INTO TRE_PREDICATEVALUE VALUES(t_predicatedid,'UNIVERSALASSET',0);
       INSERT INTO TRE_EXPNODE 
       VALUES(nextval('TRE_EXPNODE_SEQ'),'Value',t_predicatedid,NULL,t_rootnodeid,(SELECT count(*) FROM TRE_EXPNODE WHERE PARENTID = t_rootnodeid),now(),now());
       RAISE NOTICE 'process complete for rule: %', t_rulesetid;
     END IF;
   END LOOP;
   CLOSE recursor;
END;
$$ language plpgsql;
