#!/bin/sh

if [[ -z $AVAILABLE_COMPONENTS ]]; then
	echo "[ERROR] Env AVAILABLE_COMPONENTS is empty!"
	exit 1
fi
if [[ -z $COMPONENTS_TO_INSTALL ]]; then
	echo "[ERROR] Env COMPONENTS_TO_INSTALL is empty!"
	exit 1
fi

PRECONFIGURED_SELECTIONS_FILE=preconfigured-selections.json

# prepare mapping file
function extract_component_mapping() {
    COMPONENT_MAPPING=$@
    COMPONENT_MAPPING=${COMPONENT_MAPPING#*[}
    COMPONENT_MAPPING=${COMPONENT_MAPPING%]*}

    for availableComponent in $COMPONENT_MAPPING
    do
    	availableComponent=${availableComponent//-/_}
    	eval $(echo ${availableComponent/:/=})
    done
}

extract_component_mapping $AVAILABLE_COMPONENTS
extract_component_mapping $HIDDEN_COMPONENTS

# get componentsToInstall from env
COMPONENTS_TO_INSTALL=${COMPONENTS_TO_INSTALL#*[}
COMPONENTS_TO_INSTALL=${COMPONENTS_TO_INSTALL%]*}

for component in $COMPONENTS_TO_INSTALL
do
	component=${component//-/_}
	componentValue=`eval echo '$'"$component"`
	if [[ -n $componentValue ]];
	then
		echo $(jq ".TO_INSTALL += [\"$componentValue\"]" $PRECONFIGURED_SELECTIONS_FILE) > $PRECONFIGURED_SELECTIONS_FILE
	fi
done
