import paramiko
import socket
import traceback
import time
import os

'''
Created on May 8, 2014

@author: elichon
'''

class DatabaseSchemaExecutor(object):

    def __init__(self):
       username = 'oracle'
       password = 'oracle'
       
       '''
                Create the SSH client
       '''
       self.client = paramiko.SSHClient()
       self.client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
       
       '''
                Create the SSH channel
       '''
       self.client.connect('dbserver', username=username, password=password)
       self.channel = self.client.invoke_shell()

       self.channel.settimeout(5.0)

    '''
       Wait for response from server
    '''
    def flush(self):
        while not self.channel.recv_ready():
             pass

        while 1:
          try:
             resp = self.channel.recv(1024)
             print resp
          except paramiko.buffered_pipe.PipeTimeout:
             break
          except socket.timeout:
             break

    def logout(self):
       self.channel.close()
       self.client.close()

    '''
       Seting timeout value for blocking mode
    '''
    def setChannelTimeout(self, timeout):
       self.channel.settimeout(timeout)

    '''
       Upload a file to remote server via SFTP
    '''
    def upload(self, source, dest):
        ftp = self.client.open_sftp()
        ftp.put(source, dest)
        ftp.close()

    def send(self, command, timeout, addLF=True):
        self.setChannelTimeout(timeout)
        self.channel.send(command + ["", "\n"][addLF])
        self.flush()

    def execute(self):
        sourceFile = 'components/BASE/ECMFSpec.xsd'
        dest_1 = '/home/oracle/scripts/install/installcms/ECMFSpec.xsd'
        dest_2 = '/home/oracle/ecmf/ECMFSpec.xsd'
    
        try:
                self.upload(sourceFile, dest_1)
                print 'ftp ECMFSpec.xsd to ' + dest_1
                self.upload(sourceFile, dest_2)
                print 'ftp ECMFSpec.xsd to ' + dest_2
    
                print ' ------------ ' + time.strftime("%H:%M:%S") + ' ------------'
                self.send('lsnrctl stop', 5)
    
                print ' ------------ ' + time.strftime("%H:%M:%S") + ' ------------'
                self.send('sqlplus / as sysdba', 5)
    
                print ' ------------ ' + time.strftime("%H:%M:%S") + ' ------------'
                self.send('shutdown immediate', 20)
    
                print ' ------------ ' + time.strftime("%H:%M:%S") + ' ------------'
                self.send('startup', 20)
    
                print ' ------------ ' + time.strftime("%H:%M:%S") + ' ------------'
                self.send('exit', 3)
    
                print ' ------------ ' + time.strftime("%H:%M:%S") + ' ------------'
                self.send('lsnrctl start', 15)
    
                print ' ------------ ' + time.strftime("%H:%M:%S") + ' ------------'
                self.send('cd /home/oracle/scripts/install/installcms', 5)
    
                print ' ------------ ' + time.strftime("%H:%M:%S") + ' ------------'
                self.send('sh db_evolve.sh ttv', 90)
        
                self.logout()
        except Exception, e:
                traceback.print_exc()
                print e
                self.logout()

if __name__ == "__main__":
    print 'Starting update the database schema'
    dse = DatabaseSchemaExecutor()
    dse.execute()
    print 'Database schema update done!'

