from InstallComponent import InstallComponent
from InstallComponentBuilder import InstallComponentBuilder
from InstallHelper import InstallHelper
from ComponentSelectionConfig import ComponentSelectionConfig
from K8sUtil import *


class InstallComponentCollector(object):
    COMPONENT_SELECTION_CONFIG = "component-selections.json"
    CUSTOMIZE_COMPONENTS_CONFIG = 'configuration/customize-components.json'
    
    def __init__(self, customerId=None):
        if os.path.exists(self.COMPONENT_SELECTION_CONFIG):
            self.fullComponentSelectionConfig = ComponentSelectionConfig.fromJson(InstallHelper.loadFromJson(self.COMPONENT_SELECTION_CONFIG))
            self.fullInstallComponents = self.fullComponentSelectionConfig.constructInstallComponents().resolveLeaves()
        
        self.customizeInstallComponents = None
        self.customer_name = None
        if os.path.exists(self.CUSTOMIZE_COMPONENTS_CONFIG) and customerId is not None:
            self.customer_name = self.__get_customization_name(customerId)
            self.__mergeCustomizeComponents(customerId)
    
    def __mergeCustomizeComponents(self, customerId):
        if not InstallHelper.loadFromJson(self.CUSTOMIZE_COMPONENTS_CONFIG)[customerId]:
            return
        
        customizeComponentsConfig = ComponentSelectionConfig.fromJson(InstallHelper.loadFromJson(self.CUSTOMIZE_COMPONENTS_CONFIG)[customerId])
        customizeComponentsConfig.rootSelection.append("CUSTOMIZATION")
        self.customizeInstallComponents = customizeComponentsConfig.constructInstallComponents().resolveLeaves()
        if not self.fullComponentSelectionConfig:
            self.fullComponentSelectionConfig = ComponentSelectionConfig()
        self.fullComponentSelectionConfig.mergeSelectionConfig(customizeComponentsConfig)
        self.fullInstallComponents = self.fullComponentSelectionConfig.constructInstallComponents().resolveLeaves()
    
    def __get_customization_name(self, customer_id):
        if InstallHelper.loadFromJson(self.CUSTOMIZE_COMPONENTS_CONFIG)[customer_id] is None:
            return
        customization_data = InstallHelper.loadFromJson(self.CUSTOMIZE_COMPONENTS_CONFIG)[customer_id]
        key = customization_data['CUSTOMIZATION']['selections'][0]
        return customization_data[key]['displayName']
    
    def processToCollectAllSelections(self, preConfiguredFile):
        if not preConfiguredFile:
            print "[ERROR] preConfiguredFile is None"
            return False
        
        componentsToInstall = InstallComponent.createEmptyInstallComponent().merge(self.customizeInstallComponents)
        
        preConfiguredSelection = InstallHelper.loadFromJson(preConfiguredFile)
        print "The preconfiguredSelection: \n", preConfiguredSelection
        componentsToInstallFromPreConfiguration = self.loadSelectionFromPreConfiguration(preConfiguredSelection)
        componentsToInstall.merge(componentsToInstallFromPreConfiguration)
        
        # TODO Leave empty componentsToDelete for future implement
        componentsToDelete = InstallComponent.createEmptyInstallComponent()
        
        return self.fullInstallComponents, componentsToInstall, componentsToDelete
    
    def saveCurrentInstalledComponents(self, componentsToInstall):
        '''
            Save the current installed components after the deployment done.
        '''
        InstallHelper.saveCurrentInstalledComponents(componentsToInstall.toJsonObject())
        
        # Save the components_to_install to configmap
        componentsToInstall = os.getenv("COMPONENTS_TO_INSTALL")
        if componentsToInstall:
            K8sUtil.patch(CONFIGMAP, PREPACK_CONFIGMAP, "installedComponents", componentsToInstall.replace("[", "").replace("]", ""))
        if self.customer_name is not None:
            K8sUtil.patch(CONFIGMAP, PREPACK_CONFIGMAP, "customization", self.customer_name)
    
    def loadSelectionFromPreConfiguration(self, preConfiguredSelection):
        builder = InstallComponentBuilder()
        componentsToInstall = builder.buildInstallComponents(preConfiguredSelection["TO_INSTALL"])
        componentsToInstall.appendBaseComponent()
        return componentsToInstall

class ComponentPathBuilder(object):
    COMPONENTS_FOLDER = "components"
    
    @staticmethod
    def getComponentsPathPrefix(pathPrefix):
        if pathPrefix:
            pathPrefix = pathPrefix + os.sep
        else:
            pathPrefix = ""
        return pathPrefix + ComponentPathBuilder.COMPONENTS_FOLDER + os.sep

