#!/usr/bin/env python
import BaseClass

from MeIdentifierCriteria import MeIdentifierCriteria
from MeEnhancedField import MeEnhancedField
from MeSubsProfileParameter import MeSubsProfileParameter
from MeFieldDefinition import MeFieldDefinition

class MeSubsProfile(BaseClass.BaseClass):
	
	# data = (NAME, PLUGIN_NAME)
	#		 (SD,		  UA)
	
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
	
	def checkExistence(self, data):
		name = data[0]
		self.cursor.execute("SELECT ID FROM ME_SUBS_PROFILE WHERE NAME='%s'" % name)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getProfileNameById(self, profileId):
		"""
		returns the profile name of the given profile id. If no profile found,
		then returns an empty string.
		"""
		self.cursor.execute("SELECT NAME FROM ME_SUBS_PROFILE WHERE ID=%d" % profileId)
		rows = self.cursor.fetchall()
		
		profileName = ""
		if len(rows):
			profileName = rows[0][0]
		
		return profileName
	
	def getProfileIdByName(self, profileName):
		"""
		returns the profile id of the given profile name. If no profile found,
		then returns False.
		"""
		return self.checkExistence([profileName])	
	
	def getNextId(self):
		return 1
	
	def backUpExisting(self, data):
		"""
		data[0]: NAME
		
		output: return the (NAME, PLUGIN_NAME) of the give ME profile name
		"""
		
		profileName = data[0]
		statement = "SELECT NAME, PLUGIN_NAME FROM ME_SUBS_PROFILE WHERE NAME = '%s'" % profileName
		
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		if len(rows) == 0:
			return []
		else:
			return rows[0]		
		
	def insert(self, id_, data):
		"""
		data[0]: NAME
		data[1]: PLUGIN_NAME
		"""
		name 			= data[0]
		pluginName 		= data[1]
		
		try:
			"""
			step.1: insert NAME and PLUGIN_NAME
			"""
			statement = "INSERT INTO ME_SUBS_PROFILE (NAME, PLUGIN_NAME) VALUES %s" % self.tupleToStr([name, pluginName])
			print statement
			self.cursor.execute(statement)

			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
		
	def update(self, data):
		"""
		data[0]: NAME
		data[1]: PLUGIN_NAME
		"""
		name 			= data[0]
		pluginName 		= data[1]
		try:
			"""
			step.1: update PLUGIN_NAME
			"""
			statement = "UPDATE ME_SUBS_PROFILE SET PLUGIN_NAME = '%s' WHERE NAME='%s'" % (pluginName, name)
			print statement
			self.cursor.execute(statement)
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
			
	def delete(self, data):
		"""
		data[0]: NAME
		data[1]: PLUGIN_NAME
		"""
		name 			= data[0]
		pluginName 		= data[1]
		
		profileId = self.checkExistence(data)
		if profileId == False:
			return

		try:
			# delete all the criteria fields
			criteriaField = MeIdentifierCriteria()
			criteriaField.deleteAll(profileId)
			
			# delete all the enhance fields
			enhanceField = MeEnhancedField()
			enhanceField.deleteAll(profileId)
			
			# delete all the field definitions
			fieldDefinition = MeFieldDefinition()
			fieldDefinition.deleteByProfile(profileId)
			
			# delete all the parameters
			parameters = MeSubsProfileParameter()
			parameters.deleteAll(profileId)
			
			# delete the profile itself
			statement = "DELETE FROM ME_SUBS_PROFILE WHERE ID = %d" % profileId
			print statement
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
			
	def getIsDelete(self, item):
		if not item.has_key("IS_DELETE"):
			return False
		else:
			return item["IS_DELETE"].lower() == "true"

def main():
	profile = MeSubsProfile()
	profile.add("testMeProfileName", "testMePlugin")
	
if __name__ == "__main__":
	main()