#!/usr/bin/env python
#
# Copyright (c) 2014 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Simon Meng
# Created: Aug 05, 2014
# Description:
# Compile python script
#

import compileall
import os
    
def main():
    cwd = os.path.dirname(os.path.realpath(__file__))
    compileall.compile_dir(cwd, maxlevels=0, force=True)
    parentPath, currentDirName = os.path.split(cwd)
    compileall.compile_dir(os.path.join(parentPath,"components/BASE/conf/opt/tandbergtv/cms/cronjob"), maxlevels=0, force=True)
             
if __name__ == "__main__":
    main()
