<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
	xmlns:signaling="urn:cablelabs:md:xsd:signaling:3.0"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">
	
	<xsl:template name="mediaMD">
		<xsl:if test="content:DubbedLanguage">
			<DubbedLanguages>
				<xsl:for-each select="content:DubbedLanguage">
					<DubbedLanguage>
						<xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
					</DubbedLanguage>
				</xsl:for-each>
			</DubbedLanguages>
		</xsl:if>
		
		<xsl:if test="content:Language">
			<Languages>
				<xsl:for-each select="content:Language">
					<Language>
						<xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
					</Language>
				</xsl:for-each>
			</Languages>
		</xsl:if>
		
		<xsl:if test="content:SubtitleLanguage">
			<SubTitleLanguages>
				<xsl:for-each select="content:SubtitleLanguage">
					<SubTitleLanguage>
						<xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
					</SubTitleLanguage>
				</xsl:for-each>
			</SubTitleLanguages>
		</xsl:if>
		
		<xsl:if test="content:Duration">
			<Duration>
				<Duration>
					<xsl:analyze-string select="content:Duration" regex="PT([0-9]{{2}})H([0-9]{{2}})M([0-9]{{2}})S">
						<xsl:matching-substring>
							<xsl:variable name="hour" select="regex-group(1)"/>
							<xsl:variable name="minute" select="regex-group(2)"/>
							<xsl:variable name="second" select="regex-group(3)"/>
							<xsl:value-of select="concat($hour, ':', $minute, ':', $second)"/>
						</xsl:matching-substring>
					</xsl:analyze-string>
				</Duration>
			</Duration>
		</xsl:if>
		
		<xsl:if test="content:Audience or content:Rating">
			<Rating>
				<xsl:if test="content:Audience">
					<TargetAudiences>
						<xsl:for-each select="content:Audience">
							<TargetAudience><xsl:value-of select="."/></TargetAudience>
						</xsl:for-each>
					</TargetAudiences>
				</xsl:if>
				
				<xsl:if test="content:Rating/@ratingSystem='MSO'">
					<MSORatings>
						<xsl:for-each select="content:Rating[@ratingSystem='MSO']">
							<MSORating><xsl:value-of select="."/></MSORating>
						</xsl:for-each>
					</MSORatings>
				</xsl:if>
				<xsl:if test="content:Rating/@ratingSystem != 'MSO'">
					<RatingValues>
						<xsl:for-each select="content:Rating[@ratingSystem != 'MSO']">
							<RatingValue>
								<System><xsl:value-of select="@ratingSystem"/></System>
								<Value><xsl:value-of select="."/></Value>
							</RatingValue>
						</xsl:for-each>
					</RatingValues>
				</xsl:if>
			</Rating>
		</xsl:if>
		
		<xsl:if test="content:EncryptionInfo/content:ReceiverType or content:EncryptionInfo/content:ReceiverVersion">
			<Receiver>
				<xsl:if test="content:EncryptionInfo/content:ReceiverType">
					<Type><xsl:value-of select="content:EncryptionInfo/content:ReceiverType"/></Type>
				</xsl:if>
				<xsl:if test="content:EncryptionInfo/content:ReceiverVersion">
					<Version>
						<Value><xsl:value-of select="content:EncryptionInfo/content:ReceiverVersion"/></Value>
					</Version>
				</xsl:if>
			</Receiver>
		</xsl:if>
		
		<xsl:if test="content:IsResumeEnabled">
			<Rights>
				<ViewingCanBeResumed><xsl:value-of select="content:IsResumeEnabled"/></ViewingCanBeResumed>
			</Rights>
		</xsl:if>
		
		<xsl:if test="content:EncryptionInfo/content:VendorName">
			<Vendor>
				<Name><xsl:value-of select="content:EncryptionInfo/content:VendorName"/></Name>
			</Vendor>
		</xsl:if>
		
		<xsl:if test="content:AudioType or content:BitRate or content:ScreenFormat">
			<Video>
				<xsl:if test="content:AudioType">
					<AudioInfos>
						<xsl:for-each select="content:AudioType">
							<AudioInfo>
								<Value><xsl:value-of select="."/></Value>
							</AudioInfo>
						</xsl:for-each>
					</AudioInfos>
				</xsl:if>
				
				<xsl:if test="content:BitRate">
					<BitRate>
						<xsl:attribute name="value"><xsl:value-of select="content:BitRate" /></xsl:attribute>
					</BitRate>
				</xsl:if>
				
				<xsl:if test="content:ScreenFormat">
					<ScreenFormat><xsl:value-of select="content:ScreenFormat"/></ScreenFormat>
				</xsl:if>
			</Video>
		</xsl:if>
		
		<xsl:if test="content:TrickModesRestricted/core:TrickModeExclusion">
			<TrickModeRestrictions>
				<TrickModeRestriction>
					<xsl:for-each select="content:TrickModesRestricted/core:TrickModeExclusion">
						<xsl:if test="@type='trick' and @scale='0.0,100'">
							<xsl:value-of>FF</xsl:value-of>
						</xsl:if>
						<xsl:if test="@type='trick' and @scale='-100,0.0'">
							<xsl:value-of>RW</xsl:value-of>
						</xsl:if>
						<xsl:if test="@type='pause'">
							<xsl:value-of>Pause</xsl:value-of>
						</xsl:if>
						
						<xsl:if test="position() != last()">
							<xsl:value-of>,</xsl:value-of>
						</xsl:if>
					</xsl:for-each>
				</TrickModeRestriction>
			</TrickModeRestrictions>
		</xsl:if>
		
		<xsl:call-template name="EncryptionMD" />
	</xsl:template>
	
	<xsl:template name="EncryptionMD">
		<xsl:if test="content:EncryptionInfo">
			<Encryption>
				<xsl:if test="content:EncryptionInfo/content:EncryptionAlgorithm">
					<Algorithm><xsl:value-of select="content:EncryptionInfo/content:EncryptionAlgorithm"/></Algorithm>
				</xsl:if>
				<xsl:if test="content:EncryptionInfo/content:EncryptionDateTime">
					<Date><xsl:value-of select="content:EncryptionInfo/content:EncryptionDateTime"/></Date>
					<Time>
						<xsl:analyze-string select="content:EncryptionInfo/content:EncryptionDateTime" regex="([0-9]{{2}}):([0-9]{{2}}):([0-9]{{2}})">
							<xsl:matching-substring>
							<xsl:variable name="hour" select="regex-group(1)"/>
							<xsl:variable name="minute" select="regex-group(2)"/>
							<xsl:variable name="second" select="regex-group(3)"/>
							<xsl:value-of select="concat($hour, ':', $minute, ':', $second)"/>
						</xsl:matching-substring>
						</xsl:analyze-string>
					</Time>
				</xsl:if>
				<xsl:if test="content:EncryptionInfo/content:EncryptionKeyBlock">
					<KeyBlock><xsl:value-of select="content:EncryptionInfo/content:EncryptionKeyBlock"/></KeyBlock>
				</xsl:if>
				<xsl:if test="content:EncryptionInfo/content:EncryptionSystemInfo">
					<SystemInfo><xsl:value-of select="content:EncryptionInfo/content:EncryptionSystemInfo"/></SystemInfo>
				</xsl:if>
				<xsl:if test="content:EncryptionInfo/content:Encryption">
					<Type><xsl:value-of select="content:EncryptionInfo/content:Encryption"/></Type>
				</xsl:if>
			</Encryption>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>