<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
exclude-result-prefixes="tns">
<xsl:import href="from/rating.xsl"/>
<xsl:import href="from/common.xsl"/>
<xsl:import href="from/additionalInfoMetadata.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Group[@type = 'MOVIE' or @type = 'PREVIEW'] | tns:TTVSpec/tns:Item[@type = 'POSTER' or @type = 'BOXCOVER' or @type='ENCRYPTED'] ">
	<xsl:if test="tns:Relation[@type='PARENT_CHILD']/tns:Target/tns:Id">
	<asset>
		<xsl:attribute name="asset_name">
			<xsl:value-of select="tns:Fields/tns:AssetName" />
		</xsl:attribute>
		<xsl:attribute name="type">
		    <xsl:if test="@type = 'MOVIE'">
		        <xsl:text>feature</xsl:text>
		    </xsl:if>
		    <xsl:if test="@type = 'PREVIEW'">
		        <xsl:text>trailer</xsl:text>
		    </xsl:if>
		    <xsl:if test="@type = 'POSTER'">
		        <xsl:text>poster</xsl:text>
		    </xsl:if>
		    <xsl:if test="@type = 'BOXCOVER'">
		        <xsl:text>poster</xsl:text>
		    </xsl:if>
		    <xsl:if test="@type = 'ENCRYPTED'">
		        <xsl:variable name="aat">
		            <xsl:call-template name="ancestorAssetType" >
		                <xsl:with-param name="assetId" select="tns:Fields/tns:Identifier/tns:Id" />
		            </xsl:call-template>
		        </xsl:variable>
		        <xsl:choose>
		            <xsl:when test="$aat = 'preview'">
		                <xsl:text>trailer</xsl:text>
		            </xsl:when>
		            <xsl:otherwise>
		                <xsl:text>feature</xsl:text>
		            </xsl:otherwise>
		        </xsl:choose>
		    </xsl:if>
		</xsl:attribute>
		<xsl:if test="tns:Fields/tns:Profile">
			<xsl:attribute name="profile">
				<xsl:value-of select="tns:Fields/tns:Profile" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:ProductInfo/tns:Name">
			<xsl:attribute name="product">
				<xsl:value-of select="tns:Fields/tns:ProductInfo/tns:Name" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:AutoImport">
			<xsl:attribute name="autoImport">
				<xsl:value-of select="tns:Fields/tns:AutoImport" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:AutoDeploy">
			<xsl:attribute name="autoDeploy">
				<xsl:value-of select="tns:Fields/tns:AutoDeploy" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:AutoDelete">
			<xsl:attribute name="autoDelete">
				<xsl:value-of select="tns:Fields/tns:AutoDelete" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Verb">
			<xsl:attribute name="verb">
				<xsl:value-of select="tns:Fields/tns:Verb" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Version/tns:Major">
			<xsl:attribute name="version">
				<xsl:value-of select="tns:Fields/tns:Version/tns:Major" />
			</xsl:attribute>
		</xsl:if>

		<metadata>
			<assetID>
				<xsl:value-of select="tns:Fields/tns:Identifier/tns:Id" />
			</assetID>
			<xsl:if test="tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id">
				<providerID>
					<xsl:value-of select="tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id" />
				</providerID>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Video/tns:ScreenFormat">
				<screenFormat>
					<xsl:value-of select="tns:Fields/tns:Video/tns:ScreenFormat" />
				</screenFormat>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Copyright/tns:MacroVisionLevel">
				<macrovisionLevel>
					<xsl:value-of select="tns:Fields/tns:Copyright/tns:MacroVisionLevel" />
				</macrovisionLevel>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Copyright/tns:CGMSA">
				<cgmsaLevel>
			<xsl:choose>
				<xsl:when test="tns:Fields/tns:Copyright/tns:CGMSA = '0'">copyfreely</xsl:when>
				<xsl:when test="tns:Fields/tns:Copyright/tns:CGMSA = '1'">copynomore</xsl:when>
				<xsl:when test="tns:Fields/tns:Copyright/tns:CGMSA = '2'">copyonce</xsl:when>
				<xsl:when test="tns:Fields/tns:Copyright/tns:CGMSA = '3'">copynever</xsl:when>
				<xsl:otherwise><xsl:value-of select="tns:Fields/tns:Copyright/tns:CGMSA"/></xsl:otherwise>
			</xsl:choose>
				</cgmsaLevel>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:PolicyProfileId">
				<policyProfileId>
					<xsl:value-of select="tns:Fields/tns:PolicyProfileId" />
				</policyProfileId>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Size/@height or tns:Fields/tns:Size/@width">
				<xsl:element name="resolution">
					<xsl:attribute name="width"><xsl:value-of select="tns:Fields/tns:Size/@width" /></xsl:attribute>
					<xsl:attribute name="height"><xsl:value-of select="tns:Fields/tns:Size/@height" /></xsl:attribute>
				</xsl:element>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:DeviceRestrictionProfileId">
				<deviceRestrictionProfileId>
					<xsl:value-of select="tns:Fields/tns:DeviceRestrictionProfileId" />
				</deviceRestrictionProfileId>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Video/tns:StreamFormat">
				<streamFormat>
					<xsl:value-of select="tns:Fields/tns:Video/tns:StreamFormat" />
				</streamFormat>
			</xsl:if>
			<xsl:for-each select="tns:Fields/tns:Video/tns:TrickModesRestricted">
				<trickModesRestricted>
					<xsl:value-of select="." />
				</trickModesRestricted>
			</xsl:for-each>
			<xsl:if test="tns:Fields/tns:Video/tns:HDContent">
				<HD>
					<xsl:value-of select="tns:Fields/tns:Video/tns:HDContent" />
				</HD>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:Resolution">
				<screenResolution>
					<xsl:value-of select="tns:Fields/tns:Content/tns:Resolution" />
				</screenResolution>
			</xsl:if>		
			<xsl:if test="tns:Fields/tns:PD">
				<PD>
					<xsl:value-of select="tns:Fields/tns:PD" />
				</PD>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:FrameRate">
				<frameRate>
					<xsl:value-of select="tns:Fields/tns:Content/tns:FrameRate" />
				</frameRate>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:Codec">
				<codec>
					<xsl:value-of select="tns:Fields/tns:Content/tns:Codec" />
				</codec>
			</xsl:if>				
			<xsl:if test="tns:Fields/tns:Description/tns:Text or tns:Fields/tns:Description/tns:Language/@value">
				<xsl:element name="description">
					<xsl:choose>
						<xsl:when test="tns:Fields/tns:Description/tns:Language/@value">
						<xsl:attribute name="language"><xsl:value-of select="tns:Fields/tns:Description/tns:Language/@value"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
						<xsl:attribute name="language">en</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>		
					<xsl:value-of select="tns:Fields/tns:Description/tns:Text" />
				</xsl:element>
			</xsl:if>
			<xsl:for-each select="tns:Fields/tns:Language">
				<language_iso639>
					<xsl:value-of select="@value" />
				</language_iso639>
			</xsl:for-each>
			<xsl:if test="tns:Fields/tns:Duration/tns:Duration">
				<runTimeSeconds>
					<xsl:choose>
						<xsl:when test="not(matches(tns:Fields/tns:Duration/tns:Duration, '\d{2}:\d{2}:\d{2}'))">
							<xsl:value-of select="tns:Fields/tns:Duration/tns:Duration"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="runTimeDuration" select="round((number(substring-before(tns:Fields/tns:Duration/tns:Duration, ':')) * 3600 
							+ number(substring-before(substring-after(tns:Fields/tns:Duration/tns:Duration, ':'), ':')) * 60 
							+ number(substring-after(substring-after(tns:Fields/tns:Duration/tns:Duration, ':'), ':'))))"/>
							<xsl:value-of select="if(tns:Fields/tns:CustomFields/tns:CustomField[@name='mediaroomExternalFlag']/@value = 'RollingBuffer')
										then number(tns:Fields/tns:CustomFields/tns:CustomField[@name='PrePaddingInSeconds']/@value) + $runTimeDuration
										+ number(tns:Fields/tns:CustomFields/tns:CustomField[@name='PostPaddingInSeconds']/@value)
										else $runTimeDuration" />
						</xsl:otherwise>
					</xsl:choose>
				</runTimeSeconds>
			</xsl:if>
			<xsl:for-each select="tns:Fields/tns:Audio">
				<audio>
					<xsl:value-of select="tns:Type" />
				</audio>
			</xsl:for-each>
			<xsl:apply-templates select="tns:Fields/tns:Rating/tns:Value" />
			<xsl:for-each select="tns:Fields/tns:SubTitleLanguage">
				<subtitleLanguage_iso639>
					<xsl:value-of select="@value" />
				</subtitleLanguage_iso639>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:DubbedLanguage">
				<dubbedLanguage_iso639>
					<xsl:value-of select="@value" />
				</dubbedLanguage_iso639>
			</xsl:for-each>
			<xsl:if test="tns:Fields/tns:CustomFields">
                <xsl:call-template name="additionalInfo">
                	<xsl:with-param name="customFieldstoSkip"
	select="('PlayoutURL', 'ParentAssetType', 'mediaroomExternalFlag','unModifiedStarttimeFromGLF')" />
                </xsl:call-template>
	        </xsl:if>
			<xsl:if test="tns:Fields/tns:CustomFields/tns:CustomField[@name='mediaroomExternalFlag']/@value != ''">
				<flag>
					<xsl:value-of select="tns:Fields/tns:CustomFields/tns:CustomField[@name='mediaroomExternalFlag']/@value" />
				</flag>
			</xsl:if>
		</metadata>
		<xsl:element name="content">
			<xsl:if test="tns:Fields/tns:Content/tns:WasPitched">
				<xsl:attribute name="wasPitched" >
					<xsl:value-of select="tns:Fields/tns:Content/tns:WasPitched" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:LastPitchDate">
				<xsl:attribute name="lastPitchDate" >
					<xsl:value-of select="tns:Fields/tns:Content/tns:LastPitchDate" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:PitchedFilename">
				<xsl:attribute name="pitchedFilename" >
					<xsl:value-of select="tns:Fields/tns:Content/tns:PitchedFilename" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:SizeInBytes">
				<xsl:attribute name="sizeInBytes" >
					<xsl:value-of select="tns:Fields/tns:Content/tns:SizeInBytes" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:Type">
				<xsl:attribute name="type" >
					<xsl:value-of select="tns:Fields/tns:Content/tns:Type" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:NetworkType">
				<xsl:attribute name="networkType" >
					<xsl:value-of select="tns:Fields/tns:Content/tns:NetworkType" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:PlayReady">
				<xsl:attribute name="Playready" >
					<xsl:value-of select="tns:Fields/tns:Content/tns:PlayReady" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:WebInitiatorUrl">
				<xsl:attribute name="webInitiatorUrl" >
					<xsl:value-of select="tns:Fields/tns:Content/tns:WebInitiatorUrl" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Content/tns:LicenseServerProxyUrl">
				<xsl:attribute name="licenseServerProxyUrl" >
					<xsl:value-of select="tns:Fields/tns:Content/tns:LicenseServerProxyUrl" />
				</xsl:attribute>
			</xsl:if>
			<xsl:choose>
			    <xsl:when test="tns:Fields/tns:Content/tns:Locator/tns:Uri != '' ">
					<xsl:choose>
						<xsl:when test="tns:Fields/tns:CustomFields/tns:CustomField[@name='PlayoutURL']/@value != ''">
							<xsl:value-of select="tns:Fields/tns:CustomFields/tns:CustomField[@name='PlayoutURL']/@value"/>
						</xsl:when>		
						<xsl:otherwise>
							<xsl:analyze-string select="fn:translate(tns:Fields/tns:Content/tns:Locator/tns:Uri, '/', '\')" regex=".*\\([^\\]+$)">
								<xsl:matching-substring>
									<xsl:value-of select="regex-group(1)"/>
								</xsl:matching-substring>
								<xsl:non-matching-substring>
								    <xsl:value-of select="."/>
								</xsl:non-matching-substring>
							</xsl:analyze-string>				
						</xsl:otherwise>
					</xsl:choose> 		   
			    </xsl:when>		
			<xsl:otherwise>
				<xsl:analyze-string select="fn:translate(tns:Fields/tns:Content/tns:Locator/tns:Uri, '/', '\')" regex=".*\\([^\\]+$)">
				    <xsl:matching-substring>
			    	    <xsl:value-of select="regex-group(1)"/>
			  	    </xsl:matching-substring>
			  	    <xsl:non-matching-substring>
			    	    <xsl:value-of select="."/>
			  	    </xsl:non-matching-substring>
			    </xsl:analyze-string>			
			</xsl:otherwise>
		    </xsl:choose> 
		</xsl:element>
	</asset>
</xsl:if>
</xsl:template>
</xsl:stylesheet>

