#!/usr/bin/env python
from xml.dom.minidom import parseString

class CMSEarApplicationXml():

	def __init__(self, applicationXmlPath):
		self.applicationXmlPath = applicationXmlPath
		self.dom = parseString(file(applicationXmlPath, "r").read())
	
	def addPrepackModules(self):
		self.addNewModule("prepack_device_services.war", "prepack_device_services")
		fout = file(self.applicationXmlPath, "w")
		self.dom.writexml(fout, encoding="UTF-8")
	
	def addNewModule(self, webUri, contextRoot):
		application = self.dom.getElementsByTagName("application")[0]
		exsitingModule = filter(lambda m : m.getElementsByTagName('web') and m.getElementsByTagName('web')[0].nodeName == 'web' and m.getElementsByTagName('web')[0].getElementsByTagName('web-uri')[0].firstChild.nodeValue == webUri, application.getElementsByTagName("module"))
		if exsitingModule:
			return
		else:
			moduleEle = self.dom.createElement("module")
			application.appendChild(moduleEle)
			
			webEle = self.dom.createElement("web")
			moduleEle.appendChild(webEle)
			
			webUriEle = self.dom.createElement("web-uri")
			webUriEle.appendChild(self.dom.createTextNode(webUri))
			contextRootEle = self.dom.createElement("context-root")
			contextRootEle.appendChild(self.dom.createTextNode(contextRoot))
			webEle.appendChild(webUriEle)
			webEle.appendChild(contextRootEle)

def main():
	app = CMSEarApplicationXml("scripts/application.xml")
	app.addPrepackModules()
	
if __name__ == "__main__":
	main()
