#!/usr/bin/env python
import BaseClass
from CMSVersionDeploymentPolicy import CMSVersionDeploymentPolicy


class SelectorKeys6X(BaseClass.BaseClass):
	
	def __init__(self):
		BaseClass.BaseClass.__init__(self, CMSVersionDeploymentPolicy.getPrepackDepolymentPolicy().getWorkflowDatabaseConnection())
		
		self.columns = "KEY, TEMPLATENAME"
		self.table = "TTV_SELECTOR_KEY"
		self.selectStatement = "SELECT S.SELECTIONKEY, S.TEMPLATENAME "\
								"FROM TTV_SELECTOR_KEY S "\


	def checkExistence(self, data):
		key = data[0]
		self.cursor.execute("SELECT * FROM TTV_SELECTOR_KEY WHERE KEY='%s'" % key)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		return 1
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO TTV_SELECTOR_KEY (KEY, TEMPLATENAME) VALUES %s" % self.tupleToStr([data[0], data[1]])
			print statement
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

	def update(self, data):
		try:
			self.delete(data)
			statement = "INSERT INTO TTV_SELECTOR_KEY (KEY, TEMPLATENAME) VALUES %s" % self.tupleToStr([data[0], data[1]])
			print statement
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
	
	def delete(self, data):
		"""delete the association between selector keys and template
		data[0]: selctor key
		data[1]: template name
		"""
		try:
			key = data[0]
			statement = "DELETE FROM TTV_SELECTOR_KEY WHERE KEY='%s'" % (key)
			print statement
			self.cursor.execute(statement)
			
			return self.commit()		
		except Exception, e:
			print e
			return self.rollback()
	
	def backUpExisting(self, args):		
		if args is None or not len(args):
			return 
		statement =  "SELECT KEY, TEMPLATENAME FROM TTV_SELECTOR_KEY WHERE KEY ='%s'" % args[0]
		print statement
		self.cursor.execute(statement)
		rows = self.cursor.fetchall()
		return rows[0] 
			
def main():
	sk = SelectorKeys6X()
	sk.export("/tmp/selectorkeys.tdf")
	
if __name__ == "__main__":
	main()