#!/usr/bin/env python
import PropertiesUtils
from BaseHandler import BaseHandler


class PropertiesFileHandler(BaseHandler):
    
    def __init__(self, dictData):
        BaseHandler.__init__(self, dictData)
        self.props = PropertiesUtils.PropertiesUtils(self.filePath)
    
    def removeEntryByKey(self):
        if not self.isValidParameter():
            return
        keyReg = r'' + str(self.key).strip() + '\s*=[^\n]*\n?'
        PropertiesUtils.writeFile(self.filePath, keyReg, "")
        print 'Remove the entry ' + self.key
    
    def updateEntryKeyByKey(self):
        if not self.isValidParameter() or self.value is None:
            return
        
        from_reg = r'' + str(self.key) + '\s*='
        to_str = str(self.value) + '='
        PropertiesUtils.writeFile(self.filePath, from_reg, to_str)
        print 'Update key from ' + str(self.key) + ' to ' + str(self.value)
            
    def addEntry(self):
        if not self.key or self.value is None:
            return
        if self.props.has_key(self.key):
            print 'Warning: Already exists the same key'
            return
        
        newEntry = self.key + '=' + self.value
        with open(self.filePath, "a") as f:
            f.write('\n' + newEntry)
        print 'Add entry: ' + newEntry
    
    def replaceEntryValueByKey(self):
        if not self.isValidParameter() or self.value is None:
            return
        
        orig_value = str(self.props.get(self.key)).strip()
        if orig_value != str(self.value).strip():
            from_reg = self.key + '\s*=\s*' + orig_value + '\s*'
            to_reg = self.key + '=' + str(self.value).strip() + '\n'
            PropertiesUtils.writeFile(self.filePath, from_reg, to_reg)
            print 'Change the value from ' + orig_value + ' to ' + self.value + ' for entry ' + self.key
    
    def removeEntryValueByKey(self):
        if not self.isValidParameter() or self.value is None:
            return
        orig_value = self.props.get(self.key).strip()
        if orig_value is None or orig_value == '':
            return
        
        orig_v_list = orig_value.split(',')
        for v in str(self.value).split(','):
            index = self.getIndex(orig_v_list, v)
            if index is not None:
                orig_v_list.pop(index)
                print 'Remove ' + str(v) + ' for entry ' + str(self.key)
        newValue = ",".join(orig_v_list)
        
        if newValue != orig_value:
            from_reg = self.key + '\s*=\s*' + orig_value + '\s*'
            to_reg = self.key + '=' + newValue + '\n'
            PropertiesUtils.writeFile(self.filePath, from_reg, to_reg)
    
    def appendEntryValueByKey(self):
        if not self.isValidParameter() or self.value is None:
            return

        orig_value = self.props.get(self.key).strip()
        if orig_value is None or orig_value == '':
            newValue = self.value
        else:
            orig_v_list = orig_value.split(',')
            for value in str(self.value).split(','):
                if self.getIndex(orig_v_list, value) is None:
                    orig_v_list.append(str(value).strip())
                    print 'Append ' + str(value) + ' for entry ' + str(self.key)
            newValue = ','.join(orig_v_list)
            
        if newValue != orig_value:
            from_reg = self.key + '\s*=\s*' + orig_value + '\s*'
            to_reg = self.key + '=' + newValue + '\n'
            PropertiesUtils.writeFile(self.filePath, from_reg, to_reg)
    
    def isValidParameter(self):
        if self.key is None:
            return False
        if not self.props.has_key(self.key):
            return False
        return True


def main():
    filePath = "C:\\Users\\echesal\\Desktop\\test.properties"
    
    data = {'filePath':filePath, 'key':'abc'}
    PropertiesFileHandler(data).removeEntryByKey()
    
#     data2 = {'filePath':filePath, 'key' :'add.entry', 'value':'test add entry'}
#     PropertiesFileHandler(data2).addEntry()
#      
#     data3 = {'filePath':filePath, 'key' :'add.entry', 'value':'update.entry.key'}
#     PropertiesFileHandler(data3).updateEntryKeyByKey()
#     
#     data4 = {'filePath':filePath, 'key' :'root.test11', 'value':'dddddd replace value'}
#     PropertiesFileHandler(data4).replaceEntryValueByKey()
#      
#     data6 = {'filePath':filePath, 'key' :'root.test1234', 'value':'cc,ee,a '}
#     PropertiesFileHandler(data6).removeEntryValueByKey()
#      
#     data5 = {'filePath':filePath, 'key' :'root.test1234', 'value':'bbb,ee,cc '}
#     PropertiesFileHandler(data5).appendEntryValueByKey()


if __name__ == "__main__":
    main()
