#!/bin/sh

MIGRATION_TOOL_PATH="/mnt/cms-prepack/installer/scripts/migration/MigrationTool.py"
TABLE_CONFIGURATION_FILE="/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/tableconfiguration.xml"

if [ -f "$MIGRATION_TOOL_PATH" ] && [ -f ${TABLE_CONFIGURATION_FILE} ]; then
  echo "updating $TABLE_CONFIGURATION_FILE"
  python ${MIGRATION_TOOL_PATH} -a REMOVE-ENTRY -f ${TABLE_CONFIGURATION_FILE} -k /tableconfiguration/table-extension[@id=\"metadataSearchColumns\"]/column[@id=\"Playout_Urls\"]
  python ${MIGRATION_TOOL_PATH} -a REMOVE-ENTRY -f ${TABLE_CONFIGURATION_FILE} -k /tableconfiguration/table-extension[@id=\"targetedTitlesAssetMetadata\"]/column[@id=\"Playout_Urls\"]

  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${TABLE_CONFIGURATION_FILE} -k /tableconfiguration/table-extension[@id=\"metadataSearchColumns\"] -v '<column id="HssPlayout_Urls">
      <name>HSS Playout URLs</name>
      <title-section>PACKAGE/MOVIE</title-section>
      <metadata-name>/Fields/Playouts/HssPlayouts/HssPlayout/Url</metadata-name>
      <width/>
</column>'

  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${TABLE_CONFIGURATION_FILE} -k /tableconfiguration/table-extension[@id=\"metadataSearchColumns\"] -v '<column id="HlsPlayout_Urls">
      <name>HLS Playout URLs</name>
      <title-section>PACKAGE/MOVIE</title-section>
      <metadata-name>/Fields/Playouts/HlsPlayouts/HlsPlayout/Url</metadata-name>
      <width/>
</column>'

  python ${MIGRATION_TOOL_PATH} -a ADD-ENTRY -f ${TABLE_CONFIGURATION_FILE} -k /tableconfiguration/table-extension[@id=\"metadataSearchColumns\"] -v '<column id="CmafPlayout_Urls">
      <name>CMAF Playout URLs</name>
      <title-section>PACKAGE/MOVIE</title-section>
      <metadata-name>/Fields/Playouts/CmafPlayouts/CmafPlayout/Url</metadata-name>
      <width/>
</column>'
fi