<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:import href="to/idMetadata.xsl"/>  
	<xsl:import href="to/packageMetadata.xsl"/>
	<xsl:import href="to/assetMetadata.xsl"/>
	<xsl:import href="to/additionalInfoMetadata.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/assetPackages">
		<xsl:element name="tns:TTVSpec">
			<xsl:apply-templates select="assetPackage[1]"/>
		</xsl:element>
	</xsl:template>
	<!-- assetPackage -->
	<xsl:template match="assetPackage">
		<xsl:element name="tns:Group">
			<xsl:attribute name="type">PACKAGE</xsl:attribute>
			<xsl:element name="tns:Fields">
				<xsl:element name="tns:TTVId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="-1"/>
					</xsl:element>
				</xsl:element>
				<xsl:apply-templates select="metadata" mode="id_metadata"/>
				<xsl:element name="tns:ProviderInfo">
					<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="@providerID"/>
						</xsl:element>
					</xsl:element>
					<xsl:if test="@providerName">
						<xsl:element name="tns:Name">
							<xsl:value-of select="@providerName"/>
						</xsl:element>
					</xsl:if>
				</xsl:element>
				<xsl:if test="@version">
					<xsl:element name="tns:Version">
						<xsl:element name="tns:Major">
							<xsl:value-of select= "@version"/>
						</xsl:element>
						<xsl:element name= "tns:Minor">
                            <xsl:value-of select= "@version"/>
                      	</xsl:element>
					</xsl:element>
				</xsl:if>
				<xsl:if test="@verb">
					<xsl:element name="tns:Verb">
						<xsl:value-of select= "@verb"/>
					</xsl:element>
				</xsl:if>
				<xsl:if test="../originalADIFile">
					<xsl:element name="tns:OriginalFile">
						<xsl:element name="tns:Path">
							<xsl:value-of select="../originalADIFile"/>
						</xsl:element>
					</xsl:element>
				</xsl:if>
				<xsl:element name="tns:MetadataSpecVersion">MSTV2</xsl:element>
			</xsl:element>
			<xsl:element name="tns:Relation">
				<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
				<xsl:element name="tns:Target">
					<xsl:element name="tns:Id">
						<xsl:value-of select="-2"/>
					</xsl:element>
				</xsl:element>
			</xsl:element>
			<xsl:for-each select="asset">
				<xsl:variable name="assetId" select="-position() - 2"/>
				<xsl:element name="tns:Relation">
					<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
					<xsl:element name="tns:Target">
						<xsl:element name="tns:Id">
							<xsl:value-of select="$assetId"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
			<xsl:apply-templates select="*"/>
		</xsl:element>
		<xsl:element name="tns:Item">
			<xsl:attribute name="type">TITLE</xsl:attribute>
			<xsl:element name="tns:Fields">
				<xsl:element name="tns:TTVId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="-2"/>
					</xsl:element>
				</xsl:element>
				<xsl:apply-templates select="metadata" mode="package_metadata"/>
				<xsl:apply-templates select="rightsMetadata" mode="package_metadata"/>
				<xsl:apply-templates select="businessMetadata" mode="package_metadata"/>
				<xsl:if test="*/additionalInfo">
	                <xsl:element name="tns:CustomFields">
	                    <xsl:apply-templates select="*/additionalInfo" mode="additional_metadata"/>
	                </xsl:element>				
				</xsl:if>
				<xsl:element name="tns:AssetName">
					<xsl:value-of select="@asset_name"/>
				</xsl:element>
				<xsl:element name="tns:ContentType">
						<xsl:value-of select="@type"/>
				</xsl:element>
				<xsl:element name="tns:ProductInfo">
					<xsl:element name="tns:Name">
						<xsl:value-of select="@product"/>
					</xsl:element>
				</xsl:element>
				<xsl:for-each select="presentationTheme">
					<xsl:element name="tns:CategoryTheme">
						<xsl:element name="tns:Name">
							<xsl:value-of select="@name"/>
						</xsl:element>
						<xsl:for-each select="theme">
							<xsl:element name="tns:Theme">
								<xsl:element name="tns:Name">
									<xsl:value-of select="@name"/>
								</xsl:element>
								<xsl:element name="tns:Value">
									<xsl:value-of select="@value"/>
								</xsl:element>
							</xsl:element>
						</xsl:for-each>
					</xsl:element>
				</xsl:for-each>
				<xsl:if test="rulesapplied">
					<xsl:element name="tns:RulesApplied">
						<xsl:value-of select="rulesapplied"/>
					</xsl:element>
				</xsl:if>				
				<xsl:for-each select="rules">
					<xsl:element name="tns:Rule">
						<xsl:value-of select="."/>
					</xsl:element>
				</xsl:for-each>
				<xsl:if test="metadata/release_year or metadata/countryRegionCode or metadata/studio or metadata/studioDisplayName or @creationDate">
					<xsl:element name="tns:CreationInfo">
						<xsl:if test="metadata/release_year">
							<xsl:element name="tns:PublicationDate">
								<xsl:value-of select="metadata/release_year"/>
							</xsl:element>
						</xsl:if>
						<xsl:if test="metadata/countryRegionCode">
							<xsl:element name="tns:Place">
								<xsl:element name="tns:Country">
									<xsl:value-of select="metadata/countryRegionCode"/>
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:if test="metadata/studio or metadata/studioDisplayName">
							<xsl:element name="tns:Studio">
								<xsl:if test="metadata/studio">
									<xsl:element name="tns:Name">
										<xsl:value-of select="metadata/studio"/>
									</xsl:element>
								</xsl:if>
								<xsl:if test="metadata/studioDisplayName">
									<xsl:element name="tns:DisplayName">
										<xsl:value-of select="metadata/studioDisplayName"/>
									</xsl:element>
								</xsl:if>
							</xsl:element>
						</xsl:if>
						<xsl:if test="@creationDate">
							<xsl:element name="tns:CreateDate">
								<xsl:value-of select="@creationDate"/>
							</xsl:element>
						</xsl:if>
					</xsl:element>
				</xsl:if>
				<xsl:apply-templates select="@*" mode="assetPackage_optional"/>
			</xsl:element>
		</xsl:element>
		<xsl:for-each select="asset">
			<xsl:variable name="assetId" select="-position() - 2"/>
			<xsl:call-template name="assetTemplate">
				<xsl:with-param name="assetId" select="$assetId"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!-- assetPackage_optional -->
	<xsl:template match="@name" mode="assetPackage_optional">
		<xsl:element name="tns:Name">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@verb" mode="assetPackage_optional">
		<xsl:element name="tns:Verb">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@version" mode="assetPackage_optional">
		<xsl:element name="tns:Version">
			<xsl:element name="tns:Major">
				<xsl:value-of select="."/>
			</xsl:element>
			<xsl:element name="tns:Minor">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@*" mode="assetPackage_optional"/>
	<!-- language -->
	<xsl:template match="@language" mode="language">
		<xsl:element name="tns:Language">
			<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
		</xsl:element>
	</xsl:template>
	<!-- end -->
	<xsl:template match="*"/>
</xsl:stylesheet>
