<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:ericsson="http://www.ericsson.com/namespaces/metadata/xsd/COD/1"
	xmlns:signaling="urn:cablelabs:md:xsd:signaling:3.0"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	version="2.0">
	
	<xsl:template match="/ADI3/Asset[@xsi:type='offer:OfferType']">
		<AssetClass>package</AssetClass>
		<MetadataSpecVersion>CableLabsVOD3.0</MetadataSpecVersion>
		
		<xsl:call-template name="AMSMD" />
		
		<xsl:if test="@creationDateTime">
			<CreationInfo>
					<CreateDate><xsl:value-of select="@creationDateTime"/></CreateDate>
			</CreationInfo>
		</xsl:if>
		
		<xsl:if test="$Offer/offer:ProviderContentTier">
			<ProviderContentTiers>
				<ProviderContentTier>
					<Value><xsl:value-of select="$Offer/offer:ProviderContentTier"/></Value>
				</ProviderContentTier>
			</ProviderContentTiers>
		</xsl:if>
		
		<CustomFields>
			<CustomField>
				<xsl:attribute name="name">OfferUriId</xsl:attribute>
				<Value><xsl:value-of select="/ADI3/Asset[@xsi:type='offer:OfferType']/@uriId"/></Value>
			</CustomField>
		</CustomFields>
	</xsl:template>
	
</xsl:stylesheet>