/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.Decision2;
import com.tandbergtv.watchpoint.studio.debugger.model.DecisionSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.NodeSimulator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.DecisionCondition;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;

public class DecisionNodeSimulator
extends NodeSimulator {
    protected List<Transition> leavingTransitions = null;

    @Override
    public void simulate() {
        this.leavingTransitions = this.node.getLeavingTransitions();
        String transitionName = null;
        if (SimulationType.FIXED_TRANSITION.equals((Object)this.simulationConfig.getSimulationType())) {
            transitionName = this.pickFixedTransition();
        } else if (SimulationType.EXECUTE.equals((Object)this.simulationConfig.getSimulationType())) {
            transitionName = this.evaluateExpression();
        }
        if (transitionName != null) {
            for (Transition current : this.leavingTransitions) {
                Transition transition = current;
                if (!transition.getName().equals(transitionName)) continue;
                this.leavingTransitions = new ArrayList<Transition>(1);
                this.leavingTransitions.add(transition);
                break;
            }
        }
    }

    protected String pickFixedTransition() {
        return this.getSimulationData().getFixedTransitionName();
    }

    protected String evaluateExpression() {
        String transitionName = null;
        Decision2 decisionNode = (Decision2)this.node;
        if (decisionNode.getDecisionExpression() != null) {
            Object result = JbpmExpressionEvaluator.evaluate((String)decisionNode.getDecisionExpression(), (ExecutionContext)this.executionContext);
            if (result == null) {
                throw new RuntimeException("decision expression '" + decisionNode.getDecisionExpression() + "' returned null");
            }
            transitionName = result.toString();
        } else {
            Iterator iter = decisionNode.getDecisionConditions().iterator();
            while (iter.hasNext() && transitionName == null) {
                DecisionCondition decisionCondition = (DecisionCondition)iter.next();
                Object result = JbpmExpressionEvaluator.evaluate((String)decisionCondition.getExpression(), (ExecutionContext)this.executionContext);
                if (!Boolean.TRUE.equals(result)) continue;
                transitionName = decisionCondition.getTransitionName();
            }
            if (transitionName == null) {
                transitionName = decisionNode.getDefaultLeavingTransition().getName();
            }
        }
        return transitionName;
    }

    public DecisionSimulationData getSimulationData() {
        DecisionSimulationData result = null;
        result = !(this.simulationConfig.getSimulationData() instanceof DecisionSimulationData) ? new DecisionSimulationData(this.simulationConfig.getSimulationData()) : (DecisionSimulationData)this.simulationConfig.getSimulationData();
        this.simulationConfig.setSimulationData(result);
        return result;
    }

    public List<Transition> getLeavingTransitions() {
        return this.leavingTransitions;
    }

    @Override
    public boolean fail() {
        return false;
    }

    @Override
    public Collection<VariableAccess> getVariables() {
        return Collections.emptyList();
    }
}

