/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LaunchConfigurationInfo {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String SET_ENTRY = "setEntry";
    private static final String LAUNCH_CONFIGURATION = "launchConfiguration";
    private static final String MAP_ENTRY = "mapEntry";
    private static final String LIST_ENTRY = "listEntry";
    private static final String SET_ATTRIBUTE = "setAttribute";
    private static final String MAP_ATTRIBUTE = "mapAttribute";
    private static final String LIST_ATTRIBUTE = "listAttribute";
    private static final String BOOLEAN_ATTRIBUTE = "booleanAttribute";
    private static final String INT_ATTRIBUTE = "intAttribute";
    private static final String STRING_ATTRIBUTE = "stringAttribute";
    private static final String TYPE = "type";
    private TreeMap fAttributes;
    private static boolean fgIsSun14x;

    static {
        String version;
        fgIsSun14x = false;
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor.startsWith("Sun Microsystems") && (version = System.getProperty("java.vm.version")).startsWith("1.4")) {
            fgIsSun14x = true;
        }
    }

    protected LaunchConfigurationInfo() {
        this.setAttributeTable(new TreeMap());
    }

    private TreeMap getAttributeTable() {
        return this.fAttributes;
    }

    private void setAttributeTable(TreeMap table) {
        this.fAttributes = table;
    }

    protected void setAttributes(Map map) {
        if (map == null) {
            this.setAttributeTable(new TreeMap());
            return;
        }
        this.setAttributeTable(new TreeMap(map));
    }

    protected String getStringAttribute(String key, String defaultValue) {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null && attr instanceof String) {
            return (String)attr;
        }
        return defaultValue;
    }

    protected int getIntAttribute(String key, int defaultValue) {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null && attr instanceof Integer) {
            return (Integer)attr;
        }
        return defaultValue;
    }

    protected boolean getBooleanAttribute(String key, boolean defaultValue) {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null && attr instanceof Boolean) {
            return (Boolean)attr;
        }
        return defaultValue;
    }

    protected List getListAttribute(String key, List defaultValue) {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null && attr instanceof List) {
            return (List)attr;
        }
        return defaultValue;
    }

    protected Set getSetAttribute(String key, Set defaultValue) {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null && attr instanceof Set) {
            return (Set)attr;
        }
        return defaultValue;
    }

    protected Map getMapAttribute(String key, Map defaultValue) {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null && attr instanceof Map) {
            return (Map)attr;
        }
        return defaultValue;
    }

    protected LaunchConfigurationInfo getCopy() {
        LaunchConfigurationInfo copy = new LaunchConfigurationInfo();
        copy.setAttributeTable(this.getAttributes());
        return copy;
    }

    protected TreeMap getAttributes() {
        return (TreeMap)this.getAttributeTable().clone();
    }

    protected void setAttribute(String key, Object value) {
        if (value == null) {
            this.getAttributeTable().remove(key);
        } else {
            this.getAttributeTable().put(key, value);
        }
    }

    protected String getAsXML() throws IOException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element configRootElement = doc.createElement(LAUNCH_CONFIGURATION);
        doc.appendChild(configRootElement);
        configRootElement.setAttribute(TYPE, "com.tandbergtv.watchpoint.studio.debugger.launchConfigurationType.jpdl");
        for (String key : this.getAttributeTable().keySet()) {
            Object value = this.getAttributeTable().get(key);
            if (value == null) continue;
            Element element = null;
            String valueString = null;
            if (value instanceof String) {
                valueString = (String)value;
                element = this.createKeyValueElement(doc, STRING_ATTRIBUTE, key, valueString);
            } else if (value instanceof Integer) {
                valueString = ((Integer)value).toString();
                element = this.createKeyValueElement(doc, INT_ATTRIBUTE, key, valueString);
            } else if (value instanceof Boolean) {
                valueString = ((Boolean)value).toString();
                element = this.createKeyValueElement(doc, BOOLEAN_ATTRIBUTE, key, valueString);
            } else if (value instanceof List) {
                element = this.createListElement(doc, LIST_ATTRIBUTE, key, (List)value);
            } else if (value instanceof Map) {
                element = this.createMapElement(doc, MAP_ATTRIBUTE, key, (Map)value);
            } else if (value instanceof Set) {
                element = this.createSetElement(doc, SET_ATTRIBUTE, key, (Set)value);
            }
            configRootElement.appendChild(element);
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    protected Element createKeyValueElement(Document doc, String elementType, String key, String value) {
        Element element = doc.createElement(elementType);
        element.setAttribute(KEY, key);
        element.setAttribute(VALUE, value);
        return element;
    }

    protected Element createListElement(Document doc, String elementType, String listKey, List list) {
        Element listElement = doc.createElement(elementType);
        listElement.setAttribute(KEY, listKey);
        for (String value : list) {
            Element element = doc.createElement(LIST_ENTRY);
            element.setAttribute(VALUE, value);
            listElement.appendChild(element);
        }
        return listElement;
    }

    protected Element createSetElement(Document doc, String elementType, String setKey, Set set) {
        Element setElement = doc.createElement(elementType);
        setElement.setAttribute(KEY, setKey);
        ArrayList list = new ArrayList(set);
        Collections.sort(list);
        Element element = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            element = doc.createElement(SET_ENTRY);
            element.setAttribute(VALUE, (String)iter.next());
            setElement.appendChild(element);
        }
        return setElement;
    }

    protected Element createMapElement(Document doc, String elementType, String mapKey, Map map) {
        Element mapElement = doc.createElement(elementType);
        mapElement.setAttribute(KEY, mapKey);
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String value = (String)map.get(key);
            Element element = doc.createElement(MAP_ENTRY);
            element.setAttribute(KEY, key);
            element.setAttribute(VALUE, value);
            mapElement.appendChild(element);
        }
        return mapElement;
    }

    protected void initializeFromXML(Element root) throws IllegalArgumentException {
        if (!root.getNodeName().equalsIgnoreCase(LAUNCH_CONFIGURATION)) {
            throw this.getInvalidFormatDebugException();
        }
        String id = root.getAttribute(TYPE);
        if (id == null) {
            throw this.getInvalidFormatDebugException();
        }
        NodeList list = root.getChildNodes();
        Node node = null;
        Element element = null;
        String nodeName = null;
        int i = 0;
        while (i < list.getLength()) {
            node = list.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                element = (Element)node;
                nodeName = element.getNodeName();
                if (nodeName.equalsIgnoreCase(STRING_ATTRIBUTE)) {
                    this.setStringAttribute(element);
                } else if (nodeName.equalsIgnoreCase(INT_ATTRIBUTE)) {
                    this.setIntegerAttribute(element);
                } else if (nodeName.equalsIgnoreCase(BOOLEAN_ATTRIBUTE)) {
                    this.setBooleanAttribute(element);
                } else if (nodeName.equalsIgnoreCase(LIST_ATTRIBUTE)) {
                    this.setListAttribute(element);
                } else if (nodeName.equalsIgnoreCase(MAP_ATTRIBUTE)) {
                    this.setMapAttribute(element);
                } else if (nodeName.equalsIgnoreCase(SET_ATTRIBUTE)) {
                    this.setSetAttribute(element);
                }
            }
            ++i;
        }
    }

    protected void setStringAttribute(Element element) throws IllegalArgumentException {
        this.setAttribute(this.getKeyAttribute(element), this.getValueAttribute(element));
    }

    protected void setIntegerAttribute(Element element) throws IllegalArgumentException {
        this.setAttribute(this.getKeyAttribute(element), new Integer(this.getValueAttribute(element)));
    }

    protected void setBooleanAttribute(Element element) throws IllegalArgumentException {
        this.setAttribute(this.getKeyAttribute(element), Boolean.valueOf(this.getValueAttribute(element)));
    }

    protected void setListAttribute(Element element) throws IllegalArgumentException {
        String listKey = element.getAttribute(KEY);
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        ArrayList<String> list = new ArrayList<String>(entryCount);
        Node node = null;
        Element selement = null;
        int i = 0;
        while (i < entryCount) {
            node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                selement = (Element)node;
                if (!selement.getNodeName().equalsIgnoreCase(LIST_ENTRY)) {
                    throw this.getInvalidFormatDebugException();
                }
                list.add(this.getValueAttribute(selement));
            }
            ++i;
        }
        this.setAttribute(listKey, list);
    }

    protected void setSetAttribute(Element element) throws IllegalArgumentException {
        String setKey = element.getAttribute(KEY);
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        HashSet<String> set = new HashSet<String>(entryCount);
        Node node = null;
        Element selement = null;
        int i = 0;
        while (i < entryCount) {
            node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                selement = (Element)node;
                if (!selement.getNodeName().equalsIgnoreCase(SET_ENTRY)) {
                    throw this.getInvalidFormatDebugException();
                }
                set.add(this.getValueAttribute(selement));
            }
            ++i;
        }
        this.setAttribute(setKey, set);
    }

    protected void setMapAttribute(Element element) throws IllegalArgumentException {
        String mapKey = element.getAttribute(KEY);
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        HashMap<String, String> map = new HashMap<String, String>(entryCount);
        Node node = null;
        Element selement = null;
        int i = 0;
        while (i < entryCount) {
            node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                selement = (Element)node;
                if (!selement.getNodeName().equalsIgnoreCase(MAP_ENTRY)) {
                    throw this.getInvalidFormatDebugException();
                }
                map.put(this.getKeyAttribute(selement), this.getValueAttribute(selement));
            }
            ++i;
        }
        this.setAttribute(mapKey, map);
    }

    protected String getKeyAttribute(Element element) throws IllegalArgumentException {
        String key = element.getAttribute(KEY);
        if (key == null) {
            throw this.getInvalidFormatDebugException();
        }
        return key;
    }

    protected String getValueAttribute(Element element) throws IllegalArgumentException {
        String value = element.getAttribute(VALUE);
        if (value == null) {
            throw this.getInvalidFormatDebugException();
        }
        return value;
    }

    protected IllegalArgumentException getInvalidFormatDebugException() {
        return new IllegalArgumentException();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LaunchConfigurationInfo)) {
            return false;
        }
        LaunchConfigurationInfo other = (LaunchConfigurationInfo)obj;
        return this.compareAttributes(this.fAttributes, other.getAttributeTable());
    }

    protected boolean compareAttributes(TreeMap map1, TreeMap map2) {
        if (map1.size() == map2.size()) {
            for (String key : map1.keySet()) {
                Object attr1 = map1.get(key);
                Object attr2 = map2.get(key);
                if (attr2 == null) {
                    return false;
                }
                if (fgIsSun14x && attr2 instanceof String & attr1 instanceof String) {
                    attr1 = ((String)attr1).replaceAll("\\r", "");
                    attr2 = ((String)attr2).replaceAll("\\r", "");
                }
                if (attr1.equals(attr2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return "com.tandbergtv.watchpoint.studio.debugger.launchConfigurationType.jpdl".hashCode() + this.fAttributes.size();
    }

    protected boolean hasAttribute(String attributeName) {
        return this.fAttributes.containsKey(attributeName);
    }

    protected Object removeAttribute(String attributeName) {
        if (attributeName != null) {
            return this.fAttributes.remove(attributeName);
        }
        return null;
    }
}

