package com.tandbergtv.watchpoint.studio.debugger.model;

/**
 * 		Represents all types of Node simulation.
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public enum SimulationType {

	DEFAULT ("DEFAULT", "Default"),
	SIMULATED_VALUES ("SIMULATED_VALUES", "Simulated Values"),
	FIXED_TRANSITION ("FIXED_TRANSITION", "Fixed Transition"),
	EXECUTE ("EXECUTE", "Execute Node"),
	SCRIPT ("SCRIPT", "Script"),
	SKIP_NODE ("SKIP_NODE", "Skip Node");

	private String value;
	private String label;
	
	SimulationType(String value, String label) {
		this.value = value;
		this.label = label;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}
}
