/**
 * Services.java
 * Created Mar 23, 2012
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;

/**
 * @author Sahil Verma
 */
public class Services {
	public static <T> T getService(Class<T> clazz) {
		return ServiceRegistry.getDefault().lookup(clazz);
	}

	/**
	 * Registers and starts the service
	 * 
	 * @param service
	 */
	public static void addService(Service service) {
		ServiceRegistry.getDefault().register(service.getServiceName(), service);

		service.start();
	}

	/**
	 * Stops and removes the specified service
	 * 
	 * @param service
	 */
	public static void removeService(Class<? extends Service> clazz) {
		ServiceRegistry registry = ServiceRegistry.getDefault();
		Service service = registry.lookup(clazz);

		if (service != null) {
			try {
				service.stop();
			} finally {
				registry.unregister(service);
			}
		}
	}

	/**
	 * Removes the specified service
	 * 
	 * @param service
	 */
	public static void removeService(String name) {
		ServiceRegistry registry = ServiceRegistry.getDefault();
		Service service = registry.lookup(name);

		if (service != null) {
			try {
				service.stop();
			} finally {
				registry.unregister(service);
			}
		}
	}
}
