package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.taskmgmt.def.Task;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.SuperState2;
import com.tandbergtv.workflow.core.graph.Loop;

/**
 * 		
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class SuperStateNodeSimulator extends AbstractMessageNodeSimulator {

	protected Collection<VariableAccess> variables = null;
	
	@Override
	public List<Transition> getLeavingTransitions() {
		SuperState2 superState = (SuperState2) node;
		ArrayList<Transition> leavingTransitions = new ArrayList<Transition>();
		if (superState.getLeavingTransitions() != null && !superState.getLeavingTransitions().isEmpty()) {
			leavingTransitions.add((Transition) superState.getLeavingTransitions().get(superState.getLeavingTransitions().size() - 1));
		}
		
		return leavingTransitions;
	}

	public void fillInnerNodeVariables(Node childNode, Map<String, VariableAccess> varMap) {
		Task task = null;
		if (childNode instanceof TaskNode) {
			task = ((TaskNode) childNode).getTask(childNode.getName());
		} else {
			task = node.getProcessDefinition().getTaskMgmtDefinition().getTask(childNode.getName());
		}
		if (task != null) {
			for (Object variable : task.getTaskController().getVariableAccesses()) {
				VariableAccess var = (VariableAccess) variable;
				if (!varMap.containsKey(var.getVariableName())) {
					VariableAccess newVar = new VariableAccess(var.getVariableName(), var.getAccess().toString(), var.getMappedName());
					varMap.put(newVar.getVariableName(), newVar);
				}
			}
		}
	}
	
	@Override
	public Collection<VariableAccess> getVariables() {
		if (variables == null) {
			Map<String, VariableAccess> varMap = new HashMap<String, VariableAccess>();
			SuperState superState = (SuperState) node;
			for (Object obj : superState.getNodes()) {
				Node childNode = Node.class.cast(obj);
				
				if (childNode instanceof Loop) {
					Loop loop = (Loop) childNode;
					for (Object loopNode : loop.getNodes()) {
						fillInnerNodeVariables((Node) loopNode, varMap);
					}
				} else {
					fillInnerNodeVariables(childNode, varMap);
				}
			}
			variables = varMap.values();
		}
		return variables;
	}

}
