package com.tandbergtv.watchpoint.studio.debugger.util;

import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.util.FileUtil;
import com.tandbergtv.watchpoint.studio.util.SemanticElementUtil;

/**
 * 		Debugger plugin utilities.
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class DebuggerUtils {

	public static WorkflowTemplate parseTemplate(InputStream in) {
		String xml;
		WorkflowTemplate template = null;
		try {
			xml = new String(FileUtil.readFile(in));
			template = SemanticElementUtil.createWorkflowTemplate(xml);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return template;
	}
	
	public static WorkflowTemplate parseWorkspaceTemplate(String path) {
		WorkflowTemplate template = null;
		try {
			IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(path));
			template = (WorkflowTemplate) parseTemplate(file.getContents());
		} catch (Exception e) {
		}
		return template;
	}

}
