package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class CommandPortListener extends SocketListener  {

    protected IRuntimeCommandFacade runtimeFacade;

    public CommandPortListener(ServerSocket serverSocket, IRuntimeCommandFacade runtimeFacade) {
        super(serverSocket);
        this.runtimeFacade = runtimeFacade;
    }

    @Override
    protected void processClientSocket(Socket clientSocket) throws IOException {
        PrintWriter sendToClient = new PrintWriter(clientSocket.getOutputStream(), true);
        BufferedReader readFromClient = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));

        CommandProtocol protocol = new CommandProtocol(runtimeFacade);

        String command;
        String commandOutcome;
        while ((command = readFromClient.readLine()) != null) {
            commandOutcome = protocol.processCommand(command);
            sendToClient.println(commandOutcome);
            if (commandOutcome.equalsIgnoreCase("bye.")) {
                break;
            }
        }

        sendToClient.close();
        readFromClient.close();
    }
}