package com.tandbergtv.watchpoint.studio.external.fs.dao;

import java.util.HashSet;
import java.util.Set;

import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessState;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.TemplateManualTaskNodeDTO;
import com.tandbergtv.watchpoint.studio.dto.TemplateMessageDTO;
import com.tandbergtv.watchpoint.studio.dto.TemplateSubProcessDTO;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.model.SemanticElementVisitor;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class ExtractDTOElementsVisitor extends SemanticElementVisitor {

    private Set<TemplateMessageDTO> messages = new HashSet<TemplateMessageDTO>();
    private Set<TemplateSubProcessDTO> subProcesses = new HashSet<TemplateSubProcessDTO>();
    private Set<TemplateManualTaskNodeDTO> manTaskNodes = new HashSet<TemplateManualTaskNodeDTO>();
    private WorkflowTemplateDTO template;

    public ExtractDTOElementsVisitor(WorkflowTemplateDTO template) {
        this.template = template;
    }

    public Set<TemplateMessageDTO> getMessages() {
        return messages;
    }


    public Set<TemplateSubProcessDTO> getSubProcesses() {
        return subProcesses;
    }


    public Set<TemplateManualTaskNodeDTO> getManTaskNodes() {
        return manTaskNodes;
    }

    public void visit(NodeDefinition nodeDefinition) {
        if (nodeDefinition.getNodeType().equals(NodeDefinitionType.SuperState)) {
            NodeGroup group = (NodeGroup) nodeDefinition.getNode();
            
            for (NodeElement ssElement : group.getNodeElements()) {
                if (ssElement instanceof NodeDefinition) {
                    NodeDefinition nd = (NodeDefinition) ssElement;
                    if (nd.getUid() != null) {
                        TemplateMessageDTO templateMessage = new TemplateMessageDTO();
                        templateMessage.setTemplate(template);
                        templateMessage.setNodeType(NodeDefinitionType.SuperState);
                        templateMessage.setNodeDefinitionName(nodeDefinition.getDefinitionName().trim());
                        templateMessage.setTemplateNodeName(nodeDefinition.getName().trim());
                        templateMessage.setSystemID(Utility.getSystemIDByMessageUID(nd.getUid()));
                        if (group.getResourceGroup() != null) {
                            templateMessage.setResourceGroupName(group.getResourceGroup().getName());
                        }

                        messages.add(templateMessage);
                    }
                }
            }
        } else if (nodeDefinition.getNodeType().equals(NodeDefinitionType.MessageNode)) {
            if (nodeDefinition.getUid() != null) {
                TemplateMessageDTO templateMessage = new TemplateMessageDTO();
                templateMessage.setMessageUID(nodeDefinition.getUid());
                templateMessage.setTemplate(template);
                templateMessage.setSystemID(Utility.getSystemIDByMessageUID(nodeDefinition.getUid()));
                templateMessage.setNodeDefinitionName(nodeDefinition.getDefinitionName().trim());
                templateMessage.setTemplateNodeName(nodeDefinition.getName().trim());
                templateMessage.setNodeType(NodeDefinitionType.MessageNode);
                if (nodeDefinition.getResourceGroup() != null) {
                    templateMessage.setResourceGroupName(nodeDefinition.getResourceGroup().getName());
                }
                
                messages.add(templateMessage);
            }
        }
    }
    
    public void visit(ProcessState processState) {
        TemplateSubProcessDTO subProcess = new TemplateSubProcessDTO();
        subProcess.setTemplate(template);
        subProcess.setSubProcessName(processState.getSubProcess().getName());
        subProcesses.add(subProcess);
    }

    public void visit(ManualTaskNode manTaskNode) {
        TemplateManualTaskNodeDTO templateManTaskNode = new TemplateManualTaskNodeDTO();
        templateManTaskNode.setName(manTaskNode.getName());
        templateManTaskNode.setTemplate(template);
        if (manTaskNode.getResourceGroup() != null) {
            templateManTaskNode.setResourceGroupName(manTaskNode.getResourceGroup().getName()); 
        }
        manTaskNodes.add(templateManTaskNode);
    }
}