package com.tandbergtv.watchpoint.studio.model;

import static junit.framework.Assert.assertFalse;
import static junit.framework.Assert.assertTrue;

import org.junit.Test;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class WPVariableTest {
    
    @Test
    public void testIsValid() {
        WPVariable wpVariable = new WPVariable();

        assertFalse("invalid name", wpVariable.isNameValid());

        wpVariable.setName("read-only");
        assertFalse("invalid name", wpVariable.isNameValid());

        wpVariable.setName("!invalidName");
        assertFalse("invalid name", wpVariable.isNameValid());

        wpVariable.setName("is invalid");
        assertFalse("invalid name", wpVariable.isNameValid());

        wpVariable.setName(" is invalid");
        assertFalse("invalid name", wpVariable.isNameValid());

        wpVariable.setName("is_valid");
        assertTrue("valid name", wpVariable.isNameValid());

        wpVariable.setName("shouldBe$Valid");
        assertTrue("valid name", wpVariable.isNameValid());
        
        wpVariable.setName("someCamelCaseVariable");
        assertTrue("valid name", wpVariable.isNameValid());

        wpVariable.setName("JUSTNOTFOLLOWINGCONVENTION");
        assertTrue("valid name", wpVariable.isNameValid());
}

}
