/**
 * PerspectiveFactory.java
 * Created Jan 14, 2010
 */
package com.tandbergtv.watchpoint.studio.ui;

import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.navigator.resources.ProjectExplorer;

import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * Sets up the studio perspective with default views
 * 
 * @author Sahil Verma
 */
public class PerspectiveFactory implements IPerspectiveFactory {

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	public void createInitialLayout(IPageLayout layout) {
 		defineLayout(layout);
 		defineActions(layout);
	}
	
	/**
	 * Defines the layout of views
	 * 
	 * @param layout
	 */
	public void defineLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();
		
		IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT, 0.25f, editorArea); //$NON-NLS-1$
		
		left.addView(ProjectExplorer.VIEW_ID);
		left.addView(Utility.ID_RESOURCE_TYPE);
		
		layout.addView(Utility.ID_OVERVIEW, IPageLayout.BOTTOM, 0.65f, "left");
		
		IFolderLayout bottom = layout.createFolder("bottom", IPageLayout.BOTTOM, 0.66f, editorArea); //$NON-NLS-1$
		
		bottom.addView(IPageLayout.ID_PROBLEM_VIEW);
		bottom.addView(Utility.ID_RESOURCE_GROUP);
		bottom.addView(IPageLayout.ID_PROP_SHEET);
		bottom.addView(IConsoleConstants.ID_CONSOLE_VIEW);
	}
	
	/**
	 * Define actions - menus, action sets as well as shortcuts in the 'Show View' menu
	 * 
	 * @param layout
	 */
	public void defineActions(IPageLayout layout) {
		layout.addActionSet(JavaUI.ID_ACTION_SET);
		layout.addActionSet(JavaUI.ID_ELEMENT_CREATION_ACTION_SET);
		layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
		
		layout.addShowViewShortcut(Utility.ID_OVERVIEW);
		layout.addShowViewShortcut(ProjectExplorer.VIEW_ID);
		layout.addShowViewShortcut(IPageLayout.ID_PROBLEM_VIEW);
		layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
		layout.addShowViewShortcut(Utility.ID_RESOURCE_TYPE);
		layout.addShowViewShortcut(Utility.ID_RESOURCE_GROUP);
		
		layout.addNewWizardShortcut("com.tandbergtv.watchpoint.studio.wizard.new.template"); //$NON-NLS-1$
		layout.addNewWizardShortcut("com.tandbergtv.watchpoint.studio.wizard.new.resourcegroup"); //$NON-NLS-1$
		layout.addNewWizardShortcut("com.tandbergtv.watchpoint.studio.wizard.new.resourcetype");
		layout.addNewWizardShortcut("org.jbpm.gd.jpdl.wizard.new.project");
	}
}
