package com.tandbergtv.watchpoint.studio.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import com.tandbergtv.watchpoint.studio.util.XMLDocumentUtility;

public class XSDTest {

    private static final String JPDL_FILE = "test-src/SSHCommand.jpdl;test-src/Target.jpdl";

    @Test
    public void test() throws SAXException, IOException, Exception {
        // 1. Lookup a factory for the W3C XML Schema language
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

        // 2. Compile the schema. 
        // Here the schema is loaded from a java.io.File, but you could use 
        // a java.net.URL or a javax.xml.transform.Source instead.
        File schemaLocation = new File("schema/jpdl-3.2-custom.xsd");
        Schema schema = factory.newSchema(schemaLocation);

        // 3. Get a validator from the schema.
        Validator validator = schema.newValidator();

        for (String jpdlFile : JPDL_FILE.split(";")) {
            
            String xmlFile = getAugmentedSource(jpdlFile);
            // 4. Parse the document you want to check.
            Source source = new StreamSource(new StringReader(xmlFile));

            // 5. Check the document
            try {
                validator.validate(source);
                System.out.println(jpdlFile + " is valid.");
            } catch (SAXException ex) {
                System.out.println(jpdlFile + " is not valid because ");
                System.out.println(ex.getMessage());
            }
        }
    }

    private String getAugmentedSource(String jpdlFile) throws Exception {
        Document doc = XMLDocumentUtility.loadFile(new FileInputStream(new File(jpdlFile)), false);
        Element node = (Element) doc.getFirstChild();

        node.setAttribute("xmlns", "urn:jbpm.org:jpdl-3.2");
        node.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        node.setAttribute("xsi:schemaLocation", "urn:jbpm.org:jpdl-3.2 jpdl-3.2.xsd");

        return XMLDocumentUtility.convertToString(doc);
    }
}