/**
 * ICommand.java
 * Created Apr 14, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.command;

/**
 * Interface for commands. A command provides a label, description and a test for whether it can
 * run.
 * 
 * @author Sahil Verma
 */
public interface ICommand {
	
	/**
	 * Runs the command 
	 */
	void execute();
	
	/**
	 * Determines if the command can be run
	 * 
	 * @return
	 */
	boolean isEnabled();
	
	/**
	 * Returns the display name
	 * @return
	 */
	String getName();
	
	/**
	 * Returns descriptive text
	 * 
	 * @return
	 */
	String getDescription();
}
