package com.tandbergtv.watchpoint.studio.ui.command;

import org.jbpm.gd.common.command.AbstractNodeCreateCommand;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.StartState;

import com.tandbergtv.watchpoint.studio.external.wpexport.impl.template.UniqueNodeNameGenerator;
import com.tandbergtv.watchpoint.studio.ui.editor.WPNodeContainer;

/**
 * Command class for creating nodes. 
 * Takes in consideration that the initial node name must be unique in the
 * whole template - considering child LoopNodes.
 * 
 * @see org.jbpm.gd.jpdl.command.NodeCreateCommand 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class WPNodeCreateCommand extends AbstractNodeCreateCommand {
		
	public void execute() {
		super.execute();
		setName();
		addAbstractNode(getNodeElementContainer(), getAbstractNode());
	}
	
	private void addAbstractNode(NodeElementContainer nodeElementContainer, AbstractNode abstractNode) {
		if (abstractNode instanceof StartState && nodeElementContainer instanceof ProcessDefinition) {
			((ProcessDefinition)nodeElementContainer).addStartState((StartState)abstractNode);
		} else {
			nodeElementContainer.addNodeElement(abstractNode);
		}
	}
	
	private void removeAbstractNode(NodeElementContainer nodeElementContainer, AbstractNode abstractNode) {
		if (abstractNode instanceof StartState && nodeElementContainer instanceof ProcessDefinition) {
			((ProcessDefinition)nodeElementContainer).removeStartState((StartState)abstractNode);
		} else {
			nodeElementContainer.removeNodeElement(abstractNode);
		}
	}
	
	private NodeElementContainer getRootNodeElementContainer() {
		if (parent instanceof WPNodeContainer) {
			WPNodeContainer container = (WPNodeContainer) parent;
			return (NodeElementContainer) container.getContainer().getSemanticElement();
		} else {
			return getNodeElementContainer();
		}
	}
	
	private NodeElementContainer getNodeElementContainer() {
		return (NodeElementContainer)parent.getSemanticElement();
	}

	
	private AbstractNode getAbstractNode() {
		return (AbstractNode)node.getSemanticElement();
	}
	
	public boolean canExecute() {
		return getNodeElementContainer().canAdd(getAbstractNode());
	}
	
	private void setName() {
		if (getAbstractNode().getName() == null) {
			UniqueNodeNameGenerator nameHelper = new UniqueNodeNameGenerator(false);
			nameHelper.setRootContainer(getRootNodeElementContainer());
			nameHelper.setUniqueNodeNameFor(getAbstractNode());
		}
	}
	
	public void undo() {
		removeAbstractNode(getNodeElementContainer(), getAbstractNode());
	}
	
}
