/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorInput;
import org.jbpm.gd.common.command.AbstractEdgeDeleteCommand;
import org.jbpm.gd.common.command.AbstractNodeCreateCommand;
import org.jbpm.gd.common.command.AbstractNodeDeleteCommand;
import org.jbpm.gd.common.notation.AbstractNodeContainer;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Label;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.common.notation.RootContainer;
import org.jbpm.gd.common.part.EdgeGraphicalEditPart;
import org.jbpm.gd.common.part.NodeContainerGraphicalEditPart;
import org.jbpm.gd.common.part.RootContainerGraphicalEditPart;
import org.jbpm.gd.common.policy.ComponentEditPolicy;
import org.jbpm.gd.common.policy.ConnectionEditPolicy;
import org.jbpm.gd.common.policy.GraphicalNodeEditPolicy;
import org.jbpm.gd.common.policy.XYLayoutEditPolicy;
import org.jbpm.gd.jpdl.command.EdgeDeleteCommand;
import org.jbpm.gd.jpdl.command.NodeDeleteCommand;

import com.tandbergtv.watchpoint.studio.ui.command.WPNodeCreateCommand;

/**
 * A factory for creating new EditParts.
 * 
 * @author Imran Naqvi
 *
 */
public class GraphicalEditPartFactory implements EditPartFactory {

    private IEditorInput editorInput;

    public GraphicalEditPartFactory(IEditorInput editorInput) {
        super();
        this.editorInput = editorInput;
    }

    /**
	 * @see org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart, java.lang.Object)
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		if (model == null) return null;
		if (model instanceof RootContainer) {
			return createRootContainerGraphicalEditPart(model);
		} else if (model instanceof AbstractNodeContainer) {
			return createNodeContainerGraphicalEditPart(model);
		} else if (model instanceof Node){
			return createNodeGraphicalEditPart(model);
		} else if (model instanceof Edge) {
			return createEdgeGraphicalEditPart(model);
		} else if (model instanceof Label) {
			return createLabelGraphicalEditPart(model);
		}
		return null;
	}
	
	/*
	 * Creates a graphical edit part for a node container.
	 */
	private EditPart createNodeContainerGraphicalEditPart(Object model) {
		return new NodeContainerGraphicalEditPart((NodeContainer)model) {
			protected XYLayoutEditPolicy createXYLayoutEditPolicy() {
				return getLayoutEditPolicy();
			}
			protected ComponentEditPolicy createComponentEditPolicy() {
				return getComponentEditPolicy();
			}
			protected GraphicalNodeEditPolicy createGraphicalNodeEditPolicy() {
				return new WPNodeGraphicalNodeEditPolicy();
			}
			@Override
			protected IFigure createFigure() {
				IFigure figure = super.createFigure();
				/* Change the NodeContainer(loop node) background color */
				figure.setBackgroundColor( new Color(null, 248, 248, 255) );
				return figure;
			}
		};
	}
	
	/*
	 * Creates a graphical edit part for a node.
	 */
	private EditPart createNodeGraphicalEditPart(Object model) {
		return new WPNodeGraphicalEditPart((Node)model, editorInput) {
			protected ComponentEditPolicy createComponentEditPolicy() {
				return getComponentEditPolicy();
			}
			protected GraphicalNodeEditPolicy createGraphicalNodeEditPolicy() {
				return new WPNodeGraphicalNodeEditPolicy();
			}
		};
	}

	/*
	 * Creates a graphical edit part for a label.
	 */
	private EditPart createLabelGraphicalEditPart(Object model) {
		return new WPLabelGraphicalEditPart((Label)model);
	}

	/*
	 * Creates a graphical edit part for a root element.
	 */
	private EditPart createRootContainerGraphicalEditPart(Object model) {
		return new RootContainerGraphicalEditPart((RootContainer)model) {
			protected XYLayoutEditPolicy createLayoutEditPolicy() {
				return getLayoutEditPolicy();
			}			
		};
	}

	/*
	 * Creates a graphical edit part for an edge.
	 */
	private EditPart createEdgeGraphicalEditPart(Object model) {
		return new EdgeGraphicalEditPart((Edge)model) {
			protected ConnectionEditPolicy getConnectionEditPolicy() {
				return new ConnectionEditPolicy() {
					protected AbstractEdgeDeleteCommand createDeleteCommand() {
						return new EdgeDeleteCommand();
					}				
				};
			}			
		};
	}
	
	/*
	 * Creates a layout edit policy.
	 */
	private XYLayoutEditPolicy getLayoutEditPolicy() {
		return new XYLayoutEditPolicy() {
			protected AbstractNodeCreateCommand createNodeCreateCommand() {
				return new WPNodeCreateCommand();
			}					
		};
	}

	/*
	 * Creates a component edit policy.
	 */
	private ComponentEditPolicy getComponentEditPolicy() {
		return new ComponentEditPolicy() {
			protected AbstractNodeDeleteCommand createDeleteCommand() {
				return new NodeDeleteCommand();
			}					
		};
	}
}
