/**
 * NodeDefinitionActionBarContributor.java
 * Created Jul 7, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

/**
 * Contributes to the action bars when the node definition editor is active
 * 
 * @author Sahil Verma
 */
public class NodeDefinitionActionBarContributor extends MultiPageEditorActionBarContributor {

	private static final String [] ACTIONS = {
		ITextEditorActionConstants.PRINT,
		ITextEditorActionConstants.DELETE, 
		ITextEditorActionConstants.SAVE,
		ITextEditorActionConstants.UNDO, 
		ITextEditorActionConstants.REDO,
		ITextEditorActionConstants.CUT, 
		ITextEditorActionConstants.COPY,
		ITextEditorActionConstants.PASTE, 
		ITextEditorActionConstants.SELECT_ALL,
		ITextEditorActionConstants.FIND, 
		IDEActionFactory.BOOKMARK.getId()
	};
	
	/**
	 * {@inheritDoc}
	 */
	public void setActivePage(IEditorPart activeEditor) {
		IActionBars actionBars = getActionBars();
		
		if (actionBars == null)
			return;
		
		if (activeEditor instanceof NodeDefinitionGraphPage)
			hookGlobalGraphicalEditorActions((NodeDefinitionGraphPage) activeEditor, actionBars);
		else if (activeEditor instanceof StructuredTextEditor)
			hookGlobalXmlEditorActions((StructuredTextEditor) activeEditor, actionBars);

		actionBars.updateActionBars();
	}

	/**
	 * Register handlers for the common actions when the XML source page is active
	 * 
	 * @param part
	 * @param actionBars
	 */
	private void hookGlobalXmlEditorActions(StructuredTextEditor part, IActionBars actionBars) {
		for (int i = 0; i < ACTIONS.length; i++)
			actionBars.setGlobalActionHandler(ACTIONS[i], part.getAction(ACTIONS[i]));
	}

	/**
	 * Register handlers for the common actions when the node definition graph page is active
	 * 
	 * @param part
	 * @param actionBars
	 */
	private void hookGlobalGraphicalEditorActions(NodeDefinitionGraphPage part, IActionBars actionBars) {
		ActionRegistry registry = part.getEditor().getActionRegistry();
		
		for (int i = 0; i < ACTIONS.length; i++)
			actionBars.setGlobalActionHandler(ACTIONS[i], registry.getAction(ACTIONS[i]));
	}
}
