package com.tandbergtv.watchpoint.studio.ui.editor;
/*
 *This class provides the NodeDefinitionActionRegistry  to set the menu for Part Viewer 
 */
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.actions.ActionFactory;

public class NodeDefinitionContextMenuProvider extends org.eclipse.gef.ContextMenuProvider {

	private NodeDefinitionActionRegistry actionRegistry;

	public NodeDefinitionContextMenuProvider(EditPartViewer viewer,
			NodeDefinitionActionRegistry registry) {
		super(viewer);
		this.actionRegistry = registry;
	}

	public void buildContextMenu(IMenuManager manager) {
		GEFActionConstants.addStandardActionGroups(manager);
		IAction action;
 		action = actionRegistry.getAction(ActionFactory.UNDO.getId());
		manager.appendToGroup(GEFActionConstants.GROUP_UNDO, action);
		action = actionRegistry.getAction(ActionFactory.REDO.getId());
		manager.appendToGroup(GEFActionConstants.GROUP_UNDO, action);
		action = actionRegistry
				.getAction(ActionFactory.DELETE.getId());
		if (action != null && action.isEnabled())
			manager.appendToGroup(GEFActionConstants.GROUP_EDIT, action);
		action = actionRegistry.getAction(ActionFactory.SAVE.getId());
		manager.appendToGroup(GEFActionConstants.GROUP_SAVE, action);

	}

}