/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.jbpm.gd.common.editor.OutlineViewer;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * The graph page for the node definition editor.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeDefinitionGraphPage extends EditorPart {

	private NodeDefinitionEditor editor;

	private NodeDefinitionGraphicalViewer graphicalViewer;

	private OutlineViewer outlineViewer;

	/**
	 * Ctor.
	 * 
	 * @param editor the editor to which this page belongs
	 */
	public NodeDefinitionGraphPage(NodeDefinitionEditor editor) {
		this.editor = editor;
	}

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		SashForm sashForm = new SashForm(parent, SWT.HORIZONTAL);
		NodeDefinition nodeDefinition = (NodeDefinition) this.editor.getRootContainer()
				.getSemanticElement();
		if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState) {
			addPalette(sashForm);
			addModelViewer(sashForm);
			sashForm.setWeights(new int[] { 15, 85 });
		}
		else {
			addModelViewer(sashForm);
			sashForm.setWeights(new int[] { 100 });
		}
	}
	
	/**
	 * It is a workaround for recursive Prevented recursive attempt to activate part exception
	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
	 */
	public void setFocus() {
		this.editor.getGraphicalViewer().getControl().setFocus(); 
	}

	/**
	 * @see org.eclipse.ui.part.EditorPart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
		SWTGraphics g = null;
		GC gc = null;
		Image image = null;

		LayerManager lm = (LayerManager) graphicalViewer.getEditPartRegistry().get(LayerManager.ID);
		IFigure figure = lm.getLayer(LayerConstants.PRINTABLE_LAYERS);

		try {

			Rectangle r = figure.getBounds();
			editor.getRootContainer().setDimension(new Dimension(r.width, r.height));
			image = new Image(Display.getDefault(), r.width, r.height);
			gc = new GC(image);
			g = new SWTGraphics(gc);
			g.translate(r.x * -1, r.y * -1);
			figure.paint(g);
			ImageLoader imageLoader = new ImageLoader();
			imageLoader.data = new ImageData[] { image.getImageData() };
			imageLoader.save(getImageSavePath(), SWT.IMAGE_JPEG);
			refreshProcessFolder();

		}
		finally {
			if (g != null) {
				g.dispose();
			}
			if (gc != null) {
				gc.dispose();
			}
			if (image != null) {
				image.dispose();
			}
		}

	}

	/**
	 * @see org.eclipse.ui.part.EditorPart#doSaveAs()
	 */
	public void doSaveAs() {
	}

	/**
	 * @see org.eclipse.ui.part.EditorPart#isDirty()
	 */
	public boolean isDirty() {
		return false;
	}

	/**
	 * @see org.eclipse.ui.part.EditorPart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * @see org.eclipse.ui.part.EditorPart#init(org.eclipse.ui.IEditorSite, org.eclipse.ui.IEditorInput)
	 */
	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		setSite(site);
		setInput(input);
	}

	/**
	 * Gets the graphical viewer for this page.
	 * 
	 * @return the graphical viewer for this page
	 */
	public NodeDefinitionGraphicalViewer getDesignerModelViewer() {
		return graphicalViewer;
	}

	/**
	 * Gets the outline viewer for this page.
	 * 
	 * @return the outline viewer for this page
	 */
	public OutlineViewer getOutlineViewer() {
		return outlineViewer;
	}

	/**
	 * Gets the editor to which this page belongs.
	 * 
	 * @return the editor to which this page belongs
	 */
	public NodeDefinitionEditor getEditor() {
		return editor;
	}

	private void addModelViewer(Composite composite) {
		graphicalViewer = editor.createGraphicalViewer();
		graphicalViewer.initControl(composite);
		getSite().setSelectionProvider(graphicalViewer);
	}

	private void addPalette(Composite composite) {
		PaletteViewer paletteViewer = new PaletteViewer();
		paletteViewer.createControl(composite);
		editor.getEditDomain().setPaletteViewer(paletteViewer);
		editor.getEditDomain().setPaletteRoot(new NodeDefinitionPaletteRoot(editor));
	}

	private void refreshProcessFolder() {
		try {
			IFile file = ((FileEditorInput) getEditorInput()).getFile();
			file.getParent().refreshLocal(1, null);
		}
		catch (CoreException e) {
			e.printStackTrace();
		}
	}

	private String getImageSavePath() {
		IFile file = ((FileEditorInput) getEditorInput()).getFile();
		String name = file.getName();
		if (name.startsWith(".gpd.") && name.length() > 7) {
			name = name.substring(5, name.length() - 3) + "jpg";
		}
		else {
			name = editor.getDefaultImageFileName();
		}
		IPath path = file.getRawLocation().removeLastSegments(1).append(name);
		return path.toOSString();
	}
}
