package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.Constants;

/**
 * This class is a replacement to NodeHeaderFigure so the breakpoint icons are shown.
 * 
 * @autor beroubach
 */
public class WPHeaderFigure extends Figure {

    private static final Font NAMEFONT = new Font(null, "Arial", 9, SWT.BOLD);
    private static final Font TYPEFONT = new Font(null, "Arial", 9, SWT.ITALIC);
    private Figure embeddedFigure;
    private Figure typeAndLabelColumn;
    private Label typeLabel;
    private Label nameLabel;
    private Label iconLabel;
    private Color foregroundColor = Constants.veryLightGray;
    private static final Color HIGHLIGHT_COLOR = new Color(null, 22, 130, 124);
    
    public WPHeaderFigure(String nodeType, boolean hideName, ImageDescriptor imageDescriptor,
            ImageDescriptor transparentImageDescriptor) {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMajorAlignment(FlowLayout.ALIGN_CENTER);
        setLayoutManager(flowLayout);
        addEmbeddedParent("", nodeType, imageDescriptor, hideName, transparentImageDescriptor);
    }

    private void addEmbeddedParent(String nodeName, String nodeType, ImageDescriptor iconDescriptor, boolean hideName,
            ImageDescriptor transparentImageDescriptor) {
        embeddedFigure = new Figure();
        ToolbarLayout layout = new ToolbarLayout(true);
        layout.setMinorAlignment(ToolbarLayout.ALIGN_CENTER);
        embeddedFigure.setLayoutManager(layout);
        addIconLabel(iconDescriptor, transparentImageDescriptor);
        addTypeAndNameColumn(nodeType, nodeName, hideName);
        add(embeddedFigure);
    }

    private void addTypeAndNameColumn(String nodeType, String nodeName, boolean hideName) {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(false);
        layout.setMinorAlignment(ToolbarLayout.ALIGN_CENTER);
        typeAndLabelColumn = new Figure();
        typeAndLabelColumn.setLayoutManager(layout);
        addTypeLabel(nodeType);
        if (!hideName) {
            addNameLabel(nodeName);
        }
        embeddedFigure.add(typeAndLabelColumn);
    }

    private void addNameLabel(String nodeName) {
        nameLabel = new Label();
        typeLabel.setBorder(new MarginBorder(2));
        nameLabel.setForegroundColor(ColorConstants.darkGray);
        nameLabel.setFont(NAMEFONT);
        nameLabel.setText(nodeName);
        typeAndLabelColumn.add(nameLabel);
    }

    private void addTypeLabel(String nodeType) {
        typeLabel = new Label();
        typeLabel.setBorder(new MarginBorder(2));
        typeLabel.setForegroundColor(ColorConstants.darkGray);
        typeLabel.setFont(TYPEFONT);
        typeLabel.setText("<<" + nodeType + ">>");
        typeAndLabelColumn.add(typeLabel);
    }

    private void addIconLabel(ImageDescriptor iconDescriptor, ImageDescriptor transparentImageDescriptor) {
        iconLabel = new Label();
        iconLabel.setBorder(new MarginBorder(2));
        iconLabel.setIcon(getNodeIcon(iconDescriptor));
        embeddedFigure.add(iconLabel);

        if (transparentImageDescriptor != null) {
            iconLabel = new Label();
            iconLabel.setBorder(new MarginBorder(2));
            iconLabel.setIcon(getNodeIcon(transparentImageDescriptor));
            embeddedFigure.add(iconLabel);
        }
    }

    private Image getNodeIcon(ImageDescriptor iconDescriptor) {
        return SharedImages.INSTANCE.getImage(iconDescriptor);
    }

    protected void paintClientArea(Graphics graphics) {
        Color foreground = graphics.getForegroundColor();
        graphics.setForegroundColor(foregroundColor);
        graphics.fillGradient(getClientArea(), true);
        graphics.setForegroundColor(foreground);
        super.paintClientArea(graphics);
    }

    public void setNodeName(String name) {
        if (name != null && nameLabel != null) {
            nameLabel.setText(name);
        }
    }

    public Label getNameLabel() {
        return nameLabel;
    }

    public void addBreakpoint(ImageDescriptor breakpointImageDescriptor) {
        Label label = (Label) embeddedFigure.getChildren().get(1);
        label.setIcon(getNodeIcon(breakpointImageDescriptor));
    }

    public void removeBreakpoint(ImageDescriptor transparentImageDescriptor) {
        Label label = (Label) embeddedFigure.getChildren().get(1);
        label.setIcon(getNodeIcon(transparentImageDescriptor));
    }

    public void removeBackgroundHighlight() {
        foregroundColor = Constants.veryLightGray;
    }

    public void addBackgroundHighlight() {
        foregroundColor = HIGHLIGHT_COLOR; 
    }
}