package com.tandbergtv.watchpoint.studio.ui.editor;

import java.beans.PropertyChangeEvent;
import java.util.List;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.jpdl.model.Transition;
import org.jbpm.gd.jpdl.notation.JpdlNodeContainer;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;

/**
 * Class that represents the LoopNode notation element. <br>
 * We need to extend the JpdlNodeContainer because that class doesn't update the transitions
 * after rename the loop node element.
 * @author Patrik Araujo
 *
 */
public class WPNodeContainer extends JpdlNodeContainer {

	@SuppressWarnings("rawtypes")
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		String eventName = evt.getPropertyName();
		/* Change the name of the node in the transition, in order to match the new name */
		if (eventName.equals("name")) {
			firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
			List edges = getArrivingEdges();
			for (int i = 0; i < edges.size(); i++) {
				Edge edge = (Edge)edges.get(i);
				((SemanticElement)edge.getSemanticElement()).removePropertyChangeListener(edge);
				((Transition)edge.getSemanticElement()).setTo((String)evt.getNewValue());
				((SemanticElement)edge.getSemanticElement()).addPropertyChangeListener(edge);
			}		
		}
		
	}

	@Override
	public void setSemanticElement(SemanticElement semanticElement) {
		super.setSemanticElement(semanticElement);
		LoopNode loopNode = (LoopNode)semanticElement;
		int index = 0;
		for (Object childNode : getNodes()) {
			Node node = (Node)childNode;
			node.setSemanticElement( loopNode.getNodeElements()[index] );
			index++;
		};
	}
	
}
