package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype;

import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class ResourceTypeEditorMatchingStrategy implements IEditorMatchingStrategy{

	@Override
	public boolean matches(IEditorReference editorRef, IEditorInput input) {
		try {
			if(editorRef.getEditorInput() instanceof ResourceTypeEditorInput){
				ResourceTypeEditorInput resourceTypeEditorInput = (ResourceTypeEditorInput) editorRef.getEditorInput();
				if(input instanceof FileEditorInput){
					FileEditorInput fileEditorInput = (FileEditorInput) input;
					
					Path resourceTypePath = new Path(resourceTypeEditorInput.getResourceType().getPath());
					if ( fileEditorInput.getFile().getFullPath().equals(resourceTypePath) ){
						return true;
					}
				}
				
				if(input instanceof ResourceTypeEditorInput){
					ResourceTypeEditorInput currentResourceTypeEditorInput = (ResourceTypeEditorInput)input;
					if(currentResourceTypeEditorInput.equals(resourceTypeEditorInput)){
						return true;
					}
				}
			}
		} catch (PartInitException e) {
			Utility.reportError("Failed to open the Resource Type Editor.", e);
		}
		return false;
	}

}
