package com.tandbergtv.watchpoint.studio.ui.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

import org.jbpm.gd.common.model.SemanticElement;

public abstract class SemanticElementVisitor {
    
    private Set<Class<?>> executedClasses = null;

    public void visit(SemanticElement semanticElement) {
        // since java does not support late binding in this case, java reflection is used to try to find 
        // proper visit method in the child implementation of this class.
        // if no correspondent method is found, nothing is done.
        
        executedClasses = new HashSet<Class<?>>();

        Class<?> currentClass = semanticElement.getClass();
        do {
            Class<?>[] interfaces = new Class<?>[currentClass.getInterfaces().length + 1];
            interfaces[0] = currentClass;
            System.arraycopy(currentClass.getInterfaces(), 0, interfaces, 1, currentClass.getInterfaces().length);
            if (searchAndExecute(semanticElement, interfaces)) {
                break;
            }
            currentClass = currentClass.getSuperclass();
        } while (currentClass != Object.class);
    }

    private boolean searchAndExecute(SemanticElement semanticElement, Class<?>[] currentInterfaces) {
        for (Class<?> i : currentInterfaces) {
            if (executedClasses.contains(i)) {
                continue;
            }
            if (i != SemanticElement.class && executeMethod(i, semanticElement)) {
                return true;
            }
            if (searchAndExecute(semanticElement, i.getInterfaces())) {
                break;
            }
        }
        return false;
    }

    private boolean executeMethod(Class<?> clazz, SemanticElement semanticElement) {
        try {
            executedClasses.add(clazz);
            Method method = this.getClass().getMethod("visit", new Class[] { clazz });
            method.invoke(this, new Object[] { semanticElement });
            return true;
        } catch (SecurityException e) {
        } catch (NoSuchMethodException e) {
        } catch (IllegalArgumentException e) {
        } catch (IllegalAccessException e) {
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        
        return false;
    }
}