package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class MessageNodeVariablesInSuperStateCellModifierOut implements ICellModifier {
    private TableViewer tableViewer;
    private String[] columnNames;
    private String[] variableMappedNames;

    public MessageNodeVariablesInSuperStateCellModifierOut(TableViewer tableViewer, String[] columnTitles) {
        this.tableViewer = tableViewer;
        this.columnNames = columnTitles;
    }

    @Override
    public boolean canModify(Object element, String property) {
        return property.equals(columnNames[3]);
    }

    @Override
    public Object getValue(Object element, String property) {
        WPVariable variable = (WPVariable) element;

        if (property.equals(columnNames[0])) {
            return variable.getMappedName();

        } else if (property.equals(columnNames[1])) {
            return variable.isAttachment();

        } else if (property.equals(columnNames[2])) {
            return variable.getValue();

        }

        String stringValue = variable.getMappedName();
        int i = variableMappedNames.length - 1;
        while (i > 0 && !stringValue.equals(variableMappedNames[i])) {
            --i;
        }
        return new Integer(i);
    }

    @Override
    public void modify(Object element, String property, Object value) {
        WPVariable variable = (WPVariable) ((TableItem) element).getData();

        if (property.equals(columnNames[3])){
            Integer index = (Integer) value;
            String variableName = variableMappedNames[index];

            variable.setName(variableName);
        }

        tableViewer.update(variable, new String[] { property });
    }

    public void setVariableMappedNames(String[] variableMappedNames) {
        this.variableMappedNames = variableMappedNames;
    }
}