package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class SuperStateVariablesCellModifier implements ICellModifier {

    private String[] columnTitles;
    private TableViewer tableViewer;

    public SuperStateVariablesCellModifier(TableViewer tableViewer, String[] columnTitles) {
        this.tableViewer = tableViewer;
        this.columnTitles = columnTitles;
    }

    @Override
    public boolean canModify(Object element, String property) {
        return property.equals(columnTitles[0]) || property.equals(columnTitles[2]);
    }

    @Override
    public Object getValue(Object element, String property) {
        WPVariable variable = (WPVariable) element;

        if (property.equals(columnTitles[0])) {
            return variable.getMappedName();

        } else if (property.equals(columnTitles[2])) {
            String[] wpDataTypes = Utility.toVariableTypeName(Utility.getWPDataTypes());
            String stringValue = variable.getEmptySafeType();
            int i = wpDataTypes.length - 1;
            while (i > 0 && !stringValue.equals(wpDataTypes[i])) {
                --i;
            }
            return new Integer(i);
        }

        return null;
    }

    @Override
    public void modify(Object element, String property, Object value) {
        WPVariable variable = (WPVariable) ((TableItem) element).getData();
        if (property.equals(columnTitles[0])) {
            variable.setMappedName((String) value);

        } else if (property.equals(columnTitles[2]) && ((Integer)value > -1)) {
            Integer index = (Integer) value;
            String newWpType = Utility.toVariableTypeName(Utility.getWPDataTypes())[index];

            variable.setType(newWpType);
        }

        tableViewer.update(variable, new String[] {property});
    }
}
