package com.tandbergtv.watchpoint.studio.ui.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.ExceptionHandlerContainer;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class WPExceptionHandlerContainerSection extends AbstractPropertySection implements PropertyChangeListener {
	
	
	private WPExceptionHandlerContainerComposite exceptionHandlerContainerComposite;

    private ExceptionHandlerContainer exceptionHandlerContainer;
	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#createControls(org.eclipse.swt.widgets.Composite,
	 *      org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage)
	{
		super.createControls(parent, aTabbedPropertySheetPage);

		Composite clientArea = this.getWidgetFactory().createFlatFormComposite(parent);
		this.exceptionHandlerContainerComposite = new WPExceptionHandlerContainerComposite(this, clientArea, this.getWidgetFactory());
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void setInput(IWorkbenchPart part, ISelection selection)
	{
		super.setInput(part, selection);
		NodeDefinition nodeDefinition = null;
		if (!(selection instanceof IStructuredSelection))
			return;

		SemanticElement element = Utility.getSemanticElement(selection);

		if (element instanceof NodeDefinition)
		{
			nodeDefinition = (NodeDefinition) element;
			this.exceptionHandlerContainer = nodeDefinition.getNode();
			refresh();
		}
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#refresh()
	 */
	@Override
	public void refresh()
	{
		super.refresh();

		this.exceptionHandlerContainerComposite.setExceptionHandlerContainer(this.exceptionHandlerContainer);
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#shouldUseExtraSpace()
	 */
	@Override
	public boolean shouldUseExtraSpace()
	{
		return true;
	}
	
	public void propertyChange(PropertyChangeEvent evt) {}
}
