/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Filter for elements in a Node Definition container of type Single Node. This filter is only for
 * the node definition editor.
 * 
 * @author Imran Naqvi
 * 
 */
public class SingleNodeNodeDefinitionContainerFilter extends WPPropertyFilter {

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		if(this.container == null)
			return false;
		
		NodeElementContainer container = this.container;
		/*
		 * If model is null then we don't want to show anything in properties view. This happens
		 * when user click on the xml source tab of the editor. Also a sigle node nodedefinition can
		 * not have a nested node definition in it.
		 */
		if (modelElement == null || modelElement instanceof NodeDefinition)
			return false;
		/*
		 * If the active container is not a node definition, then the current container is not a
		 * node definition
		 */
		if (!(container instanceof NodeDefinition))
			return false;
		NodeDefinition root = (NodeDefinition) container;

		return root.getNodeType() == NodeDefinitionType.MessageNode;
	}

}
