package com.tandbergtv.watchpoint.studio.ui.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

/**
 * 		Loads the Resolutions from a properties file.
 * @author <a href="francisco.neto@venturus.org.br">vntfrne Francisco Bento da Silva Neto</a>
 *
 */
public class ResolutionConfig extends Properties
{
	/**
	 * 
	 */
	private static final long serialVersionUID = -9033237554511674020L;

	private static final String RESOURCE_PATH = "/Resolutions.properties";

	// Singleton Instance
	private static ResolutionConfig instance;

	private ResolutionConfig() 
	{
		super();
		try {
			this.loadProperties();
		} catch (Exception e) {
		}
	}

	/**
	 * Singleton Accessor.
	 * 
	 * @return The Properties singleton instance
	 * @throws InvalidPropertiesFormatException
	 *             The Properties format is invalid
	 * @throws IOException
	 *             Failure to read the load the Properties
	 */
	public static synchronized ResolutionConfig getInstance() {
		if (instance == null)
		{
			instance = new ResolutionConfig();
		}

		return instance;
	}

    public String getResolutionMessage(String resolutionCode, Object... params)
	{
		String message = this.getProperty(resolutionCode);
		if (message == null) {
			message = "";
		}

        return MessageFormat.format(message, params[0]);
	}

	/*
	 * Initialize the Properties by loading the values from the Validation Messages Properties file.
	 */
	private void loadProperties() throws InvalidPropertiesFormatException, IOException
	{
		this.load(ResolutionConfig.class.getResourceAsStream(RESOURCE_PATH));
	}
}
