package com.tandbergtv.watchpoint.studio.ui.util;

import static junit.framework.Assert.assertFalse;
import static junit.framework.Assert.assertTrue;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.junit.Before;
import org.junit.Test;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;

public class UtilityTest {

    private TableViewer tableViewer;
    private Controller controller;
    private StartState startState;

    @Before
    public void setup() {
        tableViewer = new TableViewer(new Shell());
        tableViewer.setContentProvider(new IStructuredContentProvider() {
            private StartState model;

            @Override
            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.model = (StartState) newInput;
            }

            @Override
            public void dispose() {
            }

            @Override
            public Object[] getElements(Object inputElement) {
                if (model != null) {
                    return model.getVariables().toArray();
                }
                return new Object[0];
            }
        });

        startState = new StartState();
        controller = new Controller();
        Task task = new Task();
        task.setController(controller);
        startState.setTask(task);

        tableViewer.setInput(startState);
    }

    private WPVariable getNewWPVariable(String variableName) {
        WPVariable variable = new WPVariable();
        variable.setMappedName(variableName); 
        variable.setName(variableName);
        variable.setType(DataType.STRING.name());
        variable.setValue("");
        variable.setAccess("read,write");
        return variable;
    }

    @Test
    public void testGetNextAvailableVariableName() {
        String result = Utility.getNextAvailableVariableName(tableViewer.getTable());
        assertTrue("correct guess", result.equals("variable1"));

        WPVariable variable = getNewWPVariable("variable2");
        controller.addVariable(variable);
        tableViewer.setInput(startState);
        result = Utility.getNextAvailableVariableName(tableViewer.getTable());
        assertTrue("correct guess", result.equals("variable1"));

        variable = getNewWPVariable("variable1");
        controller.addVariable(variable);
        tableViewer.setInput(startState);
        result = Utility.getNextAvailableVariableName(tableViewer.getTable());
        assertTrue("correct guess", result.equals("variable3"));

        variable = getNewWPVariable("variable3");
        controller.addVariable(variable);
        tableViewer.setInput(startState);
        result = Utility.getNextAvailableVariableName(tableViewer.getTable());

        assertTrue("correct guess", result.equals("variable4"));
    }
}