/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;

/**
 * View class for showing the validation errors view. This view shows all the validation messages
 * for a template when it is validated.
 * 
 * @author Imran Naqvi
 * 
 */
@Deprecated
public class ValidationErrorsView extends ViewPart implements IPartListener2 {

	private static final String ELEMENT_TYPE_COLUMN = "Element Type";

	private static final String ELEMENT_NAME_COLUMN = "Element Name";

	private static final String DESCRIPTION_COLUMN = "Description";

	private TreeViewer treeViewer;

	private Action validateAction;

	private IValidationService validationService;

	private ValidationContentProvider contentProvider;

	/**
	 * Constuctor.
	 */
	public ValidationErrorsView() {
		super();
		this.validationService = ValidationServiceFactory.createFactory().createValidationService();
	}

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parent) {
		setPartName("Validation Errors");

		/* Setting layout and layout data for parent */
		parent.setLayout(new GridLayout());
		parent.setLayoutData(getLayoutData());
		/* Creating tree panel */
		Composite treePanel = new Composite(parent, SWT.BORDER);
		treePanel.setLayout(new GridLayout(1, true));
		treePanel.setLayoutData(getTreePanelData());
		treePanel.pack();
		createTreeViewer(treePanel);
		parent.pack();

		/* Create actions and toolbar */
		createActions();
		createToolbar();

		/* Add self as a PartListener */
		this.getSite().getWorkbenchWindow().getPartService().addPartListener(this);
	}

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
	 */
	@Override
	public void setFocus() {
		this.treeViewer.getControl().setFocus();
	}

	/**
	 * Update the Validation Messages being displayed.
	 * 
	 * @param messages
	 */
	public void updateValidationMessages(List<ValidationMessage> messages) {
		List<ValidationMessage> inputMessages = new ArrayList<ValidationMessage>();
		if (messages != null)
			inputMessages.addAll(messages);

		this.treeViewer.getTree().setRedraw(false);
		try {
			this.treeViewer.setInput(inputMessages);
			this.treeViewer.expandToLevel(2);
		}
		finally {
			this.treeViewer.getTree().setRedraw(true);
		}
	}

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#dispose()
	 */
	@Override
	public void dispose() {
		super.dispose();

		// Unregister from services
		this.getSite().getWorkbenchWindow().getPartService().removePartListener(this);
	}

	/*
	 * Gets the layout data for the tree panel. @return
	 */
	private GridData getTreePanelData() {
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, true);
		return data;
	}

	/*
	 * Gets the layout data for the tree view.
	 * 
	 * @return
	 */
	private GridData getLayoutData() {
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, true, 5, 5);
		data.minimumHeight = 300;
		return data;
	}

	/*
	 * Creates the tree viewer. @param treePanel the panel in which to create the treeviewer
	 */
	private void createTreeViewer(Composite treePanel) {
		treeViewer = new TreeViewer(treePanel, SWT.SINGLE);

		treeViewer.getTree().setHeaderVisible(true);
		// Set up the table
		Tree tree = treeViewer.getTree();
		TreeColumn column = new TreeColumn(tree, SWT.LEFT);
		column.setText(DESCRIPTION_COLUMN);
		column.setWidth(400);
		column = new TreeColumn(tree, SWT.LEFT);
		column.setText(ELEMENT_NAME_COLUMN);
		column.setWidth(200);
		column = new TreeColumn(tree, SWT.LEFT);
		column.setText(ELEMENT_TYPE_COLUMN);
		column.setWidth(200);

		treeViewer.getTree().setLinesVisible(true);
		treeViewer.getTree().setLayout(new GridLayout());
		treeViewer.getTree().setLayoutData(
				new GridData(GridData.FILL_BOTH | SWT.H_SCROLL | SWT.V_SCROLL));
		this.contentProvider = new ValidationContentProvider();
		treeViewer.setContentProvider(this.contentProvider);
		treeViewer.setLabelProvider(new ValidationLabelProvider());
		treeViewer.setInput(new ArrayList<ValidationMessage>());
		treeViewer.expandAll();
	}

	/*
	 * Validates the WatchPoint entity displayed in the Active Editor.
	 */
	private void validate() {
		/* clear all existing validations */
		this.updateValidationMessages(null);

		/* Do nothing if editor is not open */
		IEditorPart editor = Utility.getActiveEditor();
		if (editor == null)
			return;

		List<ValidationMessage> messages = null;

		/* Handle the Workflow Template Editor */
		if (editor instanceof WatchPointTemplateEditor) {
			WorkflowTemplate template = ((WatchPointTemplateEditor) editor).getProcessDefinition();
			if (template == null)
				return;
			messages = validationService.validateTemplate(template);
		}

		/* Handle the Node Definition Editor */
		else if (editor instanceof NodeDefinitionEditor) {
			NodeDefinition nodeDefinition = ((NodeDefinitionEditor) editor).getNodeDefinition();
			if (nodeDefinition == null)
				return;
			messages = validationService.validateNodeDefinition(nodeDefinition);
		}

		/* Handle the Resource Type Editor */
		else if (editor instanceof ResourceTypeEditor) {
			ResourceType resourceType = ((ResourceTypeEditor) editor).getResourceType();
			if (resourceType == null)
				return;
			messages = validationService.validateResourceType(resourceType);
		}

		this.updateValidationMessages(messages);
	}

	/*
	 * Creates all the toolbar actions.
	 */
	private void createActions() {
		validateAction = new ViewAction(this, "Validate") {
			public void performAction() {
				validate();
			}
		};

		validateAction.setImageDescriptor(Utility.getImageDescriptor("validate.png"));
		validateAction.setToolTipText("Validate");
	}

	/*
	 * Create toolbar.
	 */
	private void createToolbar() {
		IToolBarManager tbManager = getViewSite().getActionBars().getToolBarManager();
		tbManager.add(validateAction);
	}

	// ========================================================================
	// ==================== IPartListener2 Methods Start
	// ========================================================================

	/**
	 * @see org.eclipse.ui.IPartListener2#partClosed(org.eclipse.ui.IWorkbenchPartReference)
	 */
	public void partClosed(IWorkbenchPartReference partRef) {
		// TODO: Need to clear validation errors if the part causing the errors to show is closed.
	}

	/**
	 * @see org.eclipse.ui.IPartListener2#partActivated(org.eclipse.ui.IWorkbenchPartReference)
	 */
	public void partActivated(IWorkbenchPartReference partRef) {
	}

	/**
	 * @see org.eclipse.ui.IPartListener2#partBroughtToTop(org.eclipse.ui.IWorkbenchPartReference)
	 */
	public void partBroughtToTop(IWorkbenchPartReference partRef) {
	}

	/**
	 * @see org.eclipse.ui.IPartListener2#partDeactivated(org.eclipse.ui.IWorkbenchPartReference)
	 */
	public void partDeactivated(IWorkbenchPartReference partRef) {
	}

	/**
	 * @see org.eclipse.ui.IPartListener2#partHidden(org.eclipse.ui.IWorkbenchPartReference)
	 */
	public void partHidden(IWorkbenchPartReference partRef) {
	}

	/**
	 * @see org.eclipse.ui.IPartListener2#partInputChanged(org.eclipse.ui.IWorkbenchPartReference)
	 */
	public void partInputChanged(IWorkbenchPartReference partRef) {
	}

	/**
	 * @see org.eclipse.ui.IPartListener2#partOpened(org.eclipse.ui.IWorkbenchPartReference)
	 */
	public void partOpened(IWorkbenchPartReference partRef) {
	}

	/**
	 * @see org.eclipse.ui.IPartListener2#partVisible(org.eclipse.ui.IWorkbenchPartReference)
	 */
	public void partVisible(IWorkbenchPartReference partRef) {
	}

	// ========================================================================
	// ==================== IPartListener2 Methods End
	// ========================================================================
}
