package com.tandbergtv.watchpoint.studio.ui.view.resourcetype.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;

/**
 * 		Command for deleting ResourceType nodes on the ResourceType explorer.
 * 
 * @author efrasio
 *
 */
public class DeleteResourceTypeNodeCommand extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
		Object toDelete = resolveTargetEntity(executionEvent);
		
		if (toDelete instanceof NodeDefinitionDTO) {
			NodeDefinitionDTO nodeDTO = (NodeDefinitionDTO) toDelete;
			if (NodeDefinitionType.SuperState.equals(nodeDTO.getType())) {
				DeleteSuperStateAction deleteAction = new DeleteSuperStateAction();
				deleteAction.run(nodeDTO);
			}
		}
		
		return null;
	}
	
	/**
	 * 		Resolves the Target entity.
	 * 
	 * @param executionEvent
	 * @return the Entity to be deleted.
	 */
	protected Object resolveTargetEntity(ExecutionEvent executionEvent) {
		Object entity = null;
		if (executionEvent.getTrigger() instanceof Event) {
			Event event = (Event) executionEvent.getTrigger();
			if (event.widget instanceof Tree) {
				Tree tree = (Tree) event.widget;
				entity = tree.getSelection()[0].getData();
			}
		}
		return entity;
	}

}
