package com.tandbergtv.watchpoint.studio.ui.view.template;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * Label provider for templates in template explorer view. This class returns the text to show in
 * the tree as well as the icon to show for it.
 * 
 * @author Imran Naqvi
 * 
 */
public class TemplateLabelProvider extends LabelProvider implements ILabelProvider {

	private static final String STANDARD_IMAGE_PATH = "template.png";

	/**
	 * @see org.eclipse.jface.viewers.LabelProvider#getText(java.lang.Object)
	 */
	@Override
	public String getText(Object element) {
		return ((WorkflowTemplateDTO) element).getName();
	}

	/**
	 * @see org.eclipse.jface.viewers.LabelProvider#getImage(java.lang.Object)
	 */
	@Override
	public Image getImage(Object element) {
		return new Image(Display.getCurrent(), Utility.getImageDescriptor(STANDARD_IMAGE_PATH).getImageData());
	}
}
