/**
 * ResourceGroupImportService.java
 * Created Feb 17, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.wizard.resource;

import java.io.File;
import java.util.Collection;

import org.eclipse.core.resources.IFolder;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.util.FileUtil;

/**
 * Imports resource groups into the local repository
 * 
 * @author Sahil Verma
 * @author Francisco Bento da Silva Neto
 */
public class ResourceGroupImportService {

	public ResourceGroupImportService() {
		super();
	}

	public void importItems(Collection<ResourceGroup> resourceGroups, IFolder destinationFolder) {
		for (ResourceGroup group : resourceGroups) {
			importItem(group, destinationFolder);
		}
	}

	protected void importItem(ResourceGroup group, IFolder baseDestinationFolder) {
		String path = group.getPath();
		File sourceFolder = new File(path);
		try {
			FileUtil.importFilesystemFolderToWorkspace(sourceFolder, baseDestinationFolder.getFolder(sourceFolder.getName()), true);
		} catch (Exception e) {
			Utility.reportError("Error import ResourceGroup: " + group.getName(), e);
		} 
	}

}
