/**
 * ResourceTypeImportWizard.java
 * Created Feb 17, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.wizard.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizardFirstPage;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ImportWizardListPage;
import com.tandbergtv.watchpoint.studio.ui.wizard.imports.ResourceTypeImportOperation;

/**
 * Imports resource type plug-ins from the file system
 * 
 * @author Patrik Araujo
 */
public class ResourceTypeImportWizard extends ImportWizard {
	private static final String LINE_SEPARATOR = System.getProperty("line.separator");

	public ResourceTypeImportWizard() {
		super(ResourceType.class, "Import Resource Type Plug-ins");
	}
	
	@Override
	public boolean performFinish() {
		page1.saveSettings(getDialogSettings());
		page2.saveSettings(getDialogSettings());
		
		if(!validateImporting()){
			return false;
		}
		
		ResourceTypeImportOperation job = new ResourceTypeImportOperation("Importing selected items", 
				page2.getSelectedModels(), page1.getBaseDirectory(), page2.isOverwriteExistingProjects());
		
		job.setUser(true);
		job.schedule();
		
		return true;
	}
	
	@Override
	public void addPages() {
		setNeedsProgressMonitor(true);
		
		page1 = new ImportWizardFirstPage("Choose Import Directory", this.clazz);
		
		/* FIXME Register providers using the extension mechanism. Also, provide a way to choose
		 * the types of import location - local repository, HTTP repository, database etc */
		page1.addProvider(ResourceType.class, new ResourceTypeDataProvider());
		
		addPage(page1);
		
		page2 = new ImportWizardListPage("Selection", page1, this.selection);
		
		addPage(page2);
	}
	
	private boolean validateImporting(){
		Map<String, List<String>> errors ;
		errors = validateResourceTypes(page2.getSelectedModels(), page1.getBaseDirectory());
		
		StringBuffer errorMessage = new StringBuffer();
		for (Entry<?, ?> entry : errors.entrySet()) {
			String resourceTypeName = (String)entry.getKey();
			errorMessage.append(resourceTypeName);
			errorMessage.append(" :" + LINE_SEPARATOR);
			for (Object message : (List<?>) entry.getValue()) {
				errorMessage.append("-" + message + LINE_SEPARATOR);
			}
		}
		
		if(!errors.isEmpty()){
			MessageDialog.openError(Display.getCurrent().getActiveShell(), "Error", errorMessage.toString());
			return false;
		}
		
		return true;
	}
	
	public Map<String, List<String>> validateResourceTypes(Collection<? extends IWatchPointDTO> models, String importLocation) throws RuntimeException{
		Map<String, List<String>> errors = new HashMap<String, List<String>>();
		
		for (IWatchPointDTO resourceTypeDTO : models) {
			ResourceType resourceType = (ResourceType)resourceTypeDTO;
			
			validateResourceType(resourceType, importLocation, errors);
		}
		
		return errors;
	}
	
	public void validateResourceType(ResourceType resourceType, String importLocation, Map<String, List<String>> errors){
		List<String> errorMessages = new ArrayList<String>();
		
		// Check if the project already exists
		if(!page2.isOverwriteExistingProjects()){
			IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resourceType.determineNameForProject());
			if(project.exists()){
				errorMessages.add("The project for the Resource Type " + resourceType.getName() + " already exists.");
			}
		}
		
		// Add new rule here ...
		
		if(!errorMessages.isEmpty()){
			errors.put(resourceType.getName(), errorMessages);
		}
	}
	
}
