package com.tandbergtv.watchpoint.studio.ui.wizard.resource.fields;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;

/**
 * Interface used by classes implementing a resource type field defined by an extension point
 * to be shown on the create new resource type wizard page.
 * @author Patrik Araujo
 */
public interface IResourceTypeInputField {
	/**
	 * Create the controls .
	 * @param parent The given composite area to be used to create the controls.
	 * @param formData The given layout data to be used by the control.
	 * @return A composite area containing the control created.
	 */
	public Composite createControls(Composite parent, FormData formData);
	
	/**
	 * Initialize the control values.<br>
	 * Each class is responsible for initialize the control values. Combobox is an example of
	 * a control that need to be initialized with the options values. 
	 */
	public void initValues();
	
	/**
	 * Sets the value from the control to the resource type.
	 * @param resourceType The resource type to have the value set.
	 */
	public void setObjectValues(ResourceType resourceType);
	
	/**
	 * Clears the control values.
	 */
	public void clearControls();
	
	/**
	 * Validates the field input.
	 * @return String containing the error message in case of error.
	 */
	public String validate();
	
	/**
	 * Sets a modify listener for the control, then the page can be validated 
	 * at the same time that the user is filling the fields.
	 * @param validationListener The listener to be set to the control.
	 */
	public void setValidationListener(ModifyListener validationListener);
	
	/**
	 * Returns the composite area created by the control. <br>
	 * This is useful cause the page can set layout data to show the control on the desired
	 * area of the page.
	 * @return
	 */
	public Composite getComposite();
	
}
