package com.tandbergtv.watchpoint.studio.ui.xml;

import org.jbpm.gd.jpdl.xml.TextDomAdapter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
 * 		Adapter for 'Text' element that doens't add padding characters.
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class TextNoPaddingDomAdapter extends TextDomAdapter {

	/**
	 * Overrides the method to avoid the padding in the
	 * Subject text.
	 */
	@Override
	protected void setTextContent(String content) {
		String oldContents = getTextContent();
		if (oldContents == null && content == null) return;
		if (oldContents.equals(content)) return;
		removeTextChildren();
		if (content != null) {
			replaceTextChild(content);
		}
	}
	
	private void removeTextChildren() {
		NodeList list = getNode().getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			if (list.item(i).getNodeType() == Node.TEXT_NODE) {
				getNode().removeChild(list.item(i));
			}
		}
	}
	
	private void replaceTextChild(String content) {
		Text text = getNode().getOwnerDocument().createTextNode(content);
		getNode().appendChild(text);
	}
}
