/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import java.util.Map;

import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.GenericElementXmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapterFactory;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.xml.ActionDomAdapter;
import org.w3c.dom.NodeList;

/**
 * Dom Adaptor class for an action element in watchpoint studio. JBPM's ActionDomAdapter had to be
 * extended due to a bug in their code in which they were not adding xml for configInfoElements.
 * Another bug was that they were doing a null check before adding the config info string.
 * 
 * @author Imran Naqvi
 * 
 */
public class WPActionDomAdapter extends ActionDomAdapter {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#setFactory(org.jbpm.gd.common.xml.XmlAdapterFactory)
	 */
	@Override
	protected void setFactory(XmlAdapterFactory factory) {
		super.setFactory(factory);
	}

	/* (non-Javadoc)
	 * @see org.jbpm.gd.jpdl.xml.ActionDomAdapter#initialize(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	public void initialize(SemanticElement jpdlElement) {
	//	initializeChildNodes(jpdlElement);
		Action action = (Action) jpdlElement;
		action.setConfigInfo(getTextContent());
		action.setClassName(getAttribute("class"));
		action.setConfigType(getAttribute("config-type"));
		action.setName(getAttribute("name"));
		action.setRefName(getAttribute("ref-name"));
		action.setAcceptPropagatedEvents(getAttribute("accept-propagated-events"));
		action.setExpression(getAttribute("expression"));
		action.setAsync(getAttribute("async"));
		action.addPropertyChangeListener(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ActionDomAdapter#getNodeTypes()
	 */
	@Override
	protected Map<?, ?> getNodeTypes() {
		return super.getNodeTypes();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ActionDomAdapter#initialize()
	 */
	@Override
	protected void initialize() {
		super.initialize();
		Action action = (Action) getSemanticElement();
		if (action != null) {
			GenericElement[] configInfoElements = action.getGenericElements();
			for (int i = 0; i < configInfoElements.length; i++) {
				addElement(configInfoElements[i]);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#getTextContent()
	 */
	@Override
	protected String getTextContent() {
		StringBuffer buffer = new StringBuffer();
		NodeList list = getNode().getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			String nodeValue = list.item(i).getNodeValue();
			if (nodeValue != null)
				buffer.append(nodeValue);
		}
		return buffer.toString().trim();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#addElement(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void addElement(XmlAdapter jpdlElementDomAdapter) {
	/*	if (jpdlElementDomAdapter instanceof GenericElementXmlAdapter) {
			XmlAdapter tempAdapter = jpdlElementDomAdapter;
			jpdlElementDomAdapter = new WPConfigInfoElementDomAdapter();
			jpdlElementDomAdapter.setNode(tempAdapter.getNode());
			((WPConfigInfoElementDomAdapter) jpdlElementDomAdapter).setWPFactory(this.getFactory());
			((WPConfigInfoElementDomAdapter) jpdlElementDomAdapter).setWPJpdlElement(tempAdapter.getSemanticElement());
			jpdlElementDomAdapter.getSemanticElement().removePropertyChangeListener(tempAdapter);
			jpdlElementDomAdapter.getSemanticElement().addPropertyChangeListener(jpdlElementDomAdapter);
			((WPConfigInfoElementDomAdapter) jpdlElementDomAdapter).WPRegister();
		}*/
		super.addElement(jpdlElementDomAdapter);
	}

	@SuppressWarnings("unused")
	private void initializeChildNodes(SemanticElement jpdlElement) {
		setSemanticElement(jpdlElement);
		NodeList nodeList = getNode().getChildNodes();
		for (int i = 0; i < nodeList.getLength(); i++) {
			XmlAdapter jpdlElementDomAdapter = getAdapter(nodeList.item(i));
			if (jpdlElementDomAdapter instanceof GenericElementXmlAdapter) {
				XmlAdapter tempAdapter = jpdlElementDomAdapter;
				jpdlElementDomAdapter = new WPConfigInfoElementDomAdapter();
				jpdlElementDomAdapter.setNode(tempAdapter.getNode());
				((WPConfigInfoElementDomAdapter) jpdlElementDomAdapter).setWPFactory(this.getFactory());
			}
			if (jpdlElementDomAdapter != null) {
				doModelAdd(jpdlElementDomAdapter);
			}
		}
		register();
	}
}
