/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.GenericElementXmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapterFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.tandbergtv.watchpoint.studio.ui.model.WPConfigInfoElement;

/**
 * Dom Adapter class for ConfogInfoElements.
 * 
 * @author Imran Naqvi
 * 
 */
public class WPConfigInfoElementDomAdapter extends GenericElementXmlAdapter {

	private static Map<String, String> NODE_TYPES = null;

	/*
	 * We need to add this factory because the base class has its setters package protected. Since
	 * we need to set this factory when we create this adaptor in the WPAdapter factory, we needed
	 * to add its own factory
	 */
	public void setWPFactory(XmlAdapterFactory factory) {
		this.setFactory(factory);
	}

	/*
	 * We need to add this method because the base class has its setters package protected. Since we
	 * need to set this element when we create this adaptor, we needed to set its jpdl element
	 */
	public void setWPJpdlElement(SemanticElement jpdlElement) {
		this.setSemanticElement(jpdlElement);
	}

	/*
	 * We need to add this method because the base class has its register method protected. Since we
	 * need to register this adaptor when we create it, we needed give access to this method
	 */
	public void WPRegister() {
		super.register();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ConfigInfoElementDomAdapter#initialize(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	public void initialize(SemanticElement jpdlElement) {
		initializeChildNodes(jpdlElement);
		WPConfigInfoElement configInfoElement = (WPConfigInfoElement) jpdlElement;
		configInfoElement.setName(getNode().getNodeName());
		configInfoElement.setValue(getTextContent());
		configInfoElement.addPropertyChangeListener(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ConfigInfoElementDomAdapter#propertyChange(java.beans.PropertyChangeEvent)
	 */
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#addElement(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void addElement(XmlAdapter jpdlElementDomAdapter) {
		if (jpdlElementDomAdapter instanceof GenericElementXmlAdapter) {
			jpdlElementDomAdapter = convertToWPAdapter((GenericElementXmlAdapter) jpdlElementDomAdapter);
		}
		super.addElement(jpdlElementDomAdapter);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#getNodeTypes()
	 */
	protected Map<String, String> getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap<String, String>();
			NODE_TYPES.put("configInfoElement", "configInfoElement");
		}
		return NODE_TYPES;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ConfigInfoElementDomAdapter#initialize()
	 */
	@Override
	protected void initialize() {
		GenericElement configInfoElement = (GenericElement) getSemanticElement();
		if (configInfoElement != null && configInfoElement.getValue() != null
				&& !configInfoElement.getValue().equals("null")) {
			setTextContent(configInfoElement.getValue());
		}
		addElements(configInfoElement.getGenericElements());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ConfigInfoElementDomAdapter#doModelAdd(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelAdd(XmlAdapter child) {
		if (!(child instanceof WPConfigInfoElementDomAdapter)) {
			child = convertToWPAdapter((GenericElementXmlAdapter) child);
		}
		String type = child.getElementType();
		SemanticElement jpdlElement;
		if ("configInfoElement".equals(type)) {
			jpdlElement = getSemanticElementFactory().createById(
					"org.jbpm.gd.jpdl.configInfoElement");
		}
		else {
			jpdlElement = createSemanticElementFor(child);
		}
		child.initialize(jpdlElement);
		WPConfigInfoElement configInfoElement = (WPConfigInfoElement) getSemanticElement();
		if ("configInfoElement".equals(type)) {
			configInfoElement.addConfigInfoElement((WPConfigInfoElement) jpdlElement);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#getTextContent()
	 */
	@Override
	protected String getTextContent() {
		StringBuffer buffer = new StringBuffer();
		NodeList list = getNode().getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			String nodeValue = list.item(i).getNodeValue();
			if (nodeValue != null)
				buffer.append(nodeValue);
		}
		return buffer.toString().trim();
	}

	/*
	 * Converts the JPDL adapter with the WatchPoint Adapter  
	 */
	private XmlAdapter convertToWPAdapter(GenericElementXmlAdapter jpdlElementDomAdapter) {
		XmlAdapter tempAdapter = jpdlElementDomAdapter;
		jpdlElementDomAdapter = new WPConfigInfoElementDomAdapter();
		jpdlElementDomAdapter.setNode(tempAdapter.getNode());
		((WPConfigInfoElementDomAdapter) jpdlElementDomAdapter).setWPFactory(this.getFactory());
		if (tempAdapter.getSemanticElement() != null) {
			((WPConfigInfoElementDomAdapter) jpdlElementDomAdapter).setWPJpdlElement(tempAdapter.getSemanticElement());
			jpdlElementDomAdapter.getSemanticElement().removePropertyChangeListener(tempAdapter);
			jpdlElementDomAdapter.getSemanticElement().addPropertyChangeListener(jpdlElementDomAdapter);
			((WPConfigInfoElementDomAdapter) jpdlElementDomAdapter).register();
		}
		return jpdlElementDomAdapter;
	}

	private void initializeChildNodes(SemanticElement jpdlElement) {
		setSemanticElement(jpdlElement);
		NodeList nodeList = getNode().getChildNodes();
		for (int i = 0; i < nodeList.getLength(); i++) {
			XmlAdapter jpdlElementDomAdapter = getAdapter(nodeList.item(i));
			if (jpdlElementDomAdapter instanceof GenericElementXmlAdapter) {
				XmlAdapter tempAdapter = jpdlElementDomAdapter;
				jpdlElementDomAdapter = new WPConfigInfoElementDomAdapter();
				jpdlElementDomAdapter.setNode(tempAdapter.getNode());
				removeElementFromAdapter(tempAdapter);
				((WPConfigInfoElementDomAdapter) jpdlElementDomAdapter).setWPFactory(this.getFactory());
			}
			if (jpdlElementDomAdapter != null) {
				doModelAdd(jpdlElementDomAdapter);
			}
		}
		register();
	}
	
	private void removeElementFromAdapter(XmlAdapter containerAdapter) {
		if (containerAdapter == null) return;
		Node last = getLastNode(getNodeType(containerAdapter.getElementType()));
		Node toDelete = containerAdapter.getNode();
		Node parent = toDelete.getParentNode();
		if (parent != null && parent == getNode()) {
			if (toDelete == last) {
				removeTextChild(toDelete.getPreviousSibling());
			} else {
				removeTextChild(toDelete.getNextSibling());
			}
			getNode().removeChild(toDelete);
			if (hasOnlyTextChildren()) {
				emptyNode();
			}
			getNode().normalize();
		}		
	}
}
